package net.spyman.utils.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.spyman.utils.SpyUtil;

public class SpyUtilBlocks
{
    /* Blocks Ores */
    public static final Block BLOCK_ORE_COPPER = new BlocksOres("copper").setUnlocalizedName("block_ore_copper").setRegistryName("block_ore_copper").setHardness(4.0F);
    public static final Block BLOCK_ORE_TIN = new BlocksOres("tin").setUnlocalizedName("block_ore_tin").setRegistryName("block_ore_tin").setHardness(3.5F);
    public static final Block BLOCK_ORE_ALUMINIUM = new BlocksOres("aluminium").setUnlocalizedName("block_ore_aluminium").setRegistryName("block_ore_aluminium").setHardness(4.0F);
    public static final Block BLOCK_ORE_LEAD = new BlocksOres("lead").setUnlocalizedName("block_ore_lead").setRegistryName("block_ore_lead").setHardness(4.0F);
    public static final Block BLOCK_ORE_SILVER = new BlocksOres("silver").setUnlocalizedName("block_ore_silver").setRegistryName("block_ore_silver").setHardness(4.0F);
    /* Decoration blocks */
    public static final Block BLOCK_LANTERN = new BlockLantern().setUnlocalizedName("block_lantern").setRegistryName("block_lantern");
    public static final Block BLOCK_LANTERN_LIT = new BlockLanternLit().setUnlocalizedName("block_lantern_lit").setRegistryName("block_lantern_lit");

    public static void registerBlocks()
    {
        GameRegistry.<Block>register(BLOCK_ORE_COPPER);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_ORE_COPPER), BLOCK_ORE_COPPER.getRegistryName());
        GameRegistry.<Block>register(BLOCK_ORE_TIN);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_ORE_TIN), BLOCK_ORE_TIN.getRegistryName());
        GameRegistry.<Block>register(BLOCK_ORE_SILVER);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_ORE_SILVER), BLOCK_ORE_SILVER.getRegistryName());
        GameRegistry.<Block>register(BLOCK_ORE_LEAD);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_ORE_LEAD), BLOCK_ORE_LEAD.getRegistryName());
        GameRegistry.<Block>register(BLOCK_ORE_ALUMINIUM);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_ORE_ALUMINIUM), BLOCK_ORE_ALUMINIUM.getRegistryName());
        GameRegistry.<Block>register(BLOCK_LANTERN);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_LANTERN), BLOCK_LANTERN.getRegistryName());
        GameRegistry.<Block>register(BLOCK_LANTERN_LIT);
        GameRegistry.<Item>register(new ItemBlock(BLOCK_LANTERN_LIT), BLOCK_LANTERN_LIT.getRegistryName());

        /* OreDictionary */

        /* OreDic : Ores Blocks */
        OreDictionary.registerOre("oreCopper", BLOCK_ORE_COPPER);
        OreDictionary.registerOre("oreTin", BLOCK_ORE_TIN);
        OreDictionary.registerOre("oreLead", BLOCK_ORE_LEAD);
        OreDictionary.registerOre("oreSilver", BLOCK_ORE_SILVER);
        OreDictionary.registerOre("oreAluminium", BLOCK_ORE_ALUMINIUM);
    }

    @SideOnly(Side.CLIENT)
    public static void registerBlocksModels()
    {
        /* Blocks Ores */
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_ORE_ALUMINIUM), 0, new ModelResourceLocation(SpyUtil.PATH + "block_ore_aluminium", "inventory"));
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_ORE_SILVER), 0, new ModelResourceLocation(SpyUtil.PATH + "block_ore_silver", "inventory"));
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_ORE_LEAD), 0, new ModelResourceLocation(SpyUtil.PATH + "block_ore_lead", "inventory"));
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_ORE_COPPER), 0, new ModelResourceLocation(SpyUtil.PATH + "block_ore_copper", "inventory"));
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_ORE_TIN), 0, new ModelResourceLocation(SpyUtil.PATH + "block_ore_tin", "inventory"));
        /* Blocks lanterns */
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_LANTERN), 0, new ModelResourceLocation(SpyUtil.PATH + "block_lantern", "inventory"));
        ModelLoader.setCustomModelResourceLocation(Item.getItemFromBlock(BLOCK_LANTERN_LIT), 0, new ModelResourceLocation(SpyUtil.PATH + "block_lantern_lit", "inventory"));
    }
}
