package net.spyman.utils;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.spyman.utils.common.blocks.SpyUtilBlocks;
import net.spyman.utils.common.events.EventHandler;
import net.spyman.utils.common.gui.GuiHandler;
import net.spyman.utils.common.items.SpyUtilItems;
import net.spyman.utils.common.recipes.SpyUtilRecipes;
import net.spyman.utils.common.world.WorldGeneration;

@Mod(name = "SpyUtil", modid = "spyutil", version = "0.1")
public class SpyUtil
{
    public static final String MODID = "spyutil";
    public static final String PATH = MODID + ":";

    @Mod.Instance("spyutil")
    public static SpyUtil INSTANCE;

    /* Creative tab */
    public static final CreativeTabs SPYUTIL_TAB = new CreativeTabs("spyutilTab")
    {
        @Override
        public Item getTabIconItem()
        {
            return Item.getItemFromBlock(SpyUtilBlocks.BLOCK_LANTERN_LIT);
        }
    };

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        /* Configuration File */
        /* Stay before all */

        

        /* Items */

        SpyUtilItems.registerItems();
        SpyUtilItems.registerItemsModels();

        /* Blocks */

        SpyUtilBlocks.registerBlocks();
        SpyUtilBlocks.registerBlocksModels();

        /* World Generation */

        WorldGeneration worldGeneration = new WorldGeneration();
        GameRegistry.registerWorldGenerator(worldGeneration, 0);

        /* Recipes */

        SpyUtilRecipes.addRecipes();

        /* TileEntity */

        // Nothing here ! only for a moment.
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event)
    {
        NetworkRegistry.INSTANCE.registerGuiHandler(INSTANCE, new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event)
    {
        /* Change stack size of some items */

        Items.ENDER_PEARL.setMaxStackSize(64);
        Items.SNOWBALL.setMaxStackSize(64);
        Items.BOAT.setMaxStackSize(64);
        Items.BUCKET.setMaxStackSize(64);
        Items.POTIONITEM.setMaxStackSize(64);

        /* Event Register */

        FMLCommonHandler.instance().bus().register(new EventHandler());
        MinecraftForge.EVENT_BUS.register(new EventHandler());
    }
}
