package mod.common.world.type;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mod.common.world.generator.ChunkProviderAncient;
import mod.common.world.structure.DimensionRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.IChunkProvider;

public class AncientWorldProvider extends WorldProvider {
	public void registerWorldChunkManager() {
		this.worldChunkMgr = new AncientWorldChunkManager(worldObj.getSeed(),
				terrainType);
		this.dimensionId = DimensionRegister.DimAncient;
		this.hasNoSky = false;
		this.isHellWorld = false;
	}

	public IChunkProvider createChunkGenerator() {
		return new ChunkProviderAncient(this.worldObj, this.worldObj.getSeed(),
				false);
	}

	public String getDimensionName() {
		return "Ancient Dimension";
	}

	public String getSaveFolder() {
		return "AncientDimension";
	}

	public boolean canRespawnHere() {
		return true;
	}

	public boolean isSurfaceWorld() {
		return true;
	}

	public boolean getWorldHasVoidParticles() {
		return true;
	}

	public int getHeight() {
		return 256;
	}

	public boolean canCoordinateBeSpawn(int par1, int par2) {
		return this.worldObj.getTopBlock(par1, par2) == Blocks.grass;
	}

	protected void generateLightBrightnessTable() {
		float f = 0.2F;

		for (int i = 0; i <= 15; ++i) {
			float f1 = 1.0F - (float) i / 15.0F;
			this.lightBrightnessTable[i] = (1.0F - f1) / (f1 * 3.0F + 1.0F)
					* (1.0F - f) + f;
		}
	}

	public float calculateCelestialAngle(long par1, float par2) {
		int j = (int) (par1 % 24000L);
		float f1 = ((float) j + par2) / 24000.0F - 0.25F;

		if (f1 < 0.0F) {
			++f1;
		}
		if (f1 > 1.0F) {
			--f1;
		}
		float f2 = f1;
		f1 = 1.0F - (float) ((Math.cos((double) f1 * Math.PI) + 1.0D) / 2.0D);
		f1 = f2 + (f1 - f2) / 3.0F;
		return f1;
	}

	public int getMoonPhase(long par1) {
		return (int) (par1 / 24000L % 8L + 8L) % 8;
	}

	public String getWelcomeMessage() {
		if (this instanceof AncientWorldProvider) {
			return "Entering the Ancient Dimension";
		}
		return null;
	}

	public String getDepartMessage() {
		if (this instanceof AncientWorldProvider) {
			return "Leaving the Ancient Dimension";
		}
		return null;
	}

	public double getMovementFactor() {
		if (this instanceof AncientWorldProvider) {
			return 10.0;
		}
		return 1.0;
	}

	@SideOnly(Side.CLIENT)
	public boolean isSkyColored() {
		return true;
	}

	@Override
	public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
		return Vec3.createVectorHelper(2.8, 1.1, 1.7);
	}
}
