package mod.common.world.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mod.common.world.generator.GenLayerAncient;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class AncientWorldChunkManager extends WorldChunkManager
{
	private GenLayer genBiomes;
	private GenLayer biomeIndexLayer;
	private BiomeCache biomeCache;
	private List<BiomeGenBase> biomesToSpawnIn;

	protected AncientWorldChunkManager()
	{
		this.biomeCache = new BiomeCache(this);
		this.biomesToSpawnIn = new ArrayList<BiomeGenBase>();
		this.biomesToSpawnIn.add(BiomeGenBase.forest);
	}

	public AncientWorldChunkManager(long par1, WorldType worldType)
	{
		this();

		GenLayer[] agenlayer = GenLayerAncient.makeTheWorld(par1);
		this.genBiomes = agenlayer[0];
		this.biomeIndexLayer = agenlayer[1];
	}

	public AncientWorldChunkManager(World world)
	{
		this(world.getSeed(), world.provider.terrainType);
	}

	public List<BiomeGenBase> getBiomesToSpawnIn()
	{
		return this.biomesToSpawnIn;
	}

	public BiomeGenBase getBiomeGenAt(int x, int z)
	{
		BiomeGenBase biome = this.biomeCache.getBiomeGenAt(x, z);
		if(biome == null)
		{
			return BiomeGenBase.forest;

		}
		return biome;
	}

	public float[] getRainfall(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5)
	{
		if(par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5)
		{
			par1ArrayOfFloat = new float[par4 * par5];
		}

		Arrays.fill(par1ArrayOfFloat, 0, par4 * par5, 0.0F);
		return par1ArrayOfFloat;
	}

	@SideOnly(Side.CLIENT)
	public float getTemperatureAtHeight(float par1, int par2)
	{
        return par1;
	}

	public BiomeGenBase[] getBiomesForGeneration(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5)
	{
		IntCache.resetIntCache();

		if(par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5)
		{
			par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
		}

		int[] aint = this.genBiomes.getInts(par2, par3, par4, par5);

		for(int i = 0; i < par4 * par5; ++i)
		{
			if(aint[i] >= 0)
			{
				par1ArrayOfBiomeGenBase[i] = BiomeGenBase.getBiome(aint[i]);
			}
			else
			{
				par1ArrayOfBiomeGenBase[i] = BiomeGenBase.forest;
			}
		}

		return par1ArrayOfBiomeGenBase;
	}

	public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5)
	{
		return this.getBiomeGenAt(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
	}

	public BiomeGenBase[] getBiomeGenAt(BiomeGenBase[] arrayOfBiomeGenBase, int x, int y, int width, int length, boolean cacheFlag)
	{
		IntCache.resetIntCache();

		if(arrayOfBiomeGenBase == null || arrayOfBiomeGenBase.length < width * length)
		{
			arrayOfBiomeGenBase = new BiomeGenBase[width * length];
		}

		if(cacheFlag && width == 16 && length == 16 && (x & 15) == 0 && (y & 15) == 0)
		{
			BiomeGenBase[] abiomegenbase1 = this.biomeCache.getCachedBiomes(x, y);
			System.arraycopy(abiomegenbase1, 0, arrayOfBiomeGenBase, 0, width * length);
			return arrayOfBiomeGenBase;
		}
		else
		{
			int[] aint = this.biomeIndexLayer.getInts(x, y, width, length);

			for(int i1 = 0; i1 < width * length; ++i1)
			{
				if(aint[i1] >= 0)
				{
					arrayOfBiomeGenBase[i1] = BiomeGenBase.getBiome(aint[i1]);
				}

				else
				{
					arrayOfBiomeGenBase[i1] = BiomeGenBase.forest;
				}
			}

			return arrayOfBiomeGenBase;
		}
	}

	public boolean areBiomesViable(int x, int y, int z, List par4List)
	{
		IntCache.resetIntCache();
		int l = x - z >> 2;
		int i1 = y - z >> 2;
		int j1 = x + z >> 2;
		int k1 = y + z >> 2;
		int l1 = j1 - l + 1;
		int i2 = k1 - i1 + 1;
		int[] aint = this.genBiomes.getInts(l, i1, l1, i2);

		for(int j2 = 0; j2 < l1 * i2; ++j2)
		{
			BiomeGenBase biomegenbase = BiomeGenBase.getBiome(aint[j2]);

			if(!par4List.contains(biomegenbase))
			{
				return false;
			}
		}

		return true;
	}

	public ChunkPosition findBiomePosition(int x, int y, int z, List list, Random rand)
	{
		return null;

	}

	public void cleanupCache()
	{
		this.biomeCache.cleanupCache();
	}
}

