package mod.common.world.structure;

import java.util.Random;

import mod.common.block.BlockRegister;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAncientAcacia extends WorldGenerator
{
	protected Block[] GetValidSpawnBlocks()
	{
		return new Block[]
		{
			Blocks.grass,
		};
	}

	public boolean LocationIsValidSpawn(World world, int x, int y, int z)
	{
		int distanceToAir = 0;
		Block checkBlock = world.getBlock(x, y, z);

		while (checkBlock != Blocks.air)
		{
			distanceToAir++;
			checkBlock = world.getBlock(x, y + distanceToAir, z);
		}

		if (distanceToAir > 1)
		{
			return false;
		}

		y += distanceToAir - 1;

		Block block = world.getBlock(x, y, z);
		Block blockAbove = world.getBlock(x, y + 1, z);
		Block blockBelow = world.getBlock(x, y - 1, z);

		for (Block i : GetValidSpawnBlocks())
		{
			if (blockAbove != Blocks.air)
			{
				return false;
			}
			if (block == i)
			{
				return true;
			}
			else if (block == Blocks.snow_layer && blockBelow == i)
			{
				return true;
			}
			else if (block.getMaterial() == Material.plants && blockBelow == i)
			{
				return true;
			}
		}
		return false;
	}

	public boolean generate(World world, Random rand, int x, int y, int z)
	{
		int i = rand.nextInt(1);

		if(i == 0)
		{
		    generate_r0(world, rand, x, y, z);
		}

       return true;

	}

	public boolean generate_r0(World world, Random rand, int x, int y, int z)
	{
		if(!LocationIsValidSpawn(world, x, y, z) || !LocationIsValidSpawn(world, x + 11, y, z) || !LocationIsValidSpawn(world, x + 11, y, z + 11) || !LocationIsValidSpawn(world, x, y, z + 11))
		{
			return false;
		}
    world.setBlock(x, y, z, Blocks.log2);
    world.setBlock(x, y + 1, z, Blocks.log2);
    world.setBlock(x, y + 2, z, Blocks.log2);
    world.setBlock(x, y + 3, z, Blocks.log2);
    world.setBlock(x, y + 4, z, Blocks.log2);
    world.setBlock(x, y + 5, z, Blocks.log2);
    world.setBlock(x, y + 6, z, Blocks.log2);
    world.setBlock(x, y + 7, z, BlockRegister.BlockTronc);
    world.setBlock(x, y + 8, z, Blocks.log2);
    world.setBlock(x + 1, y + 9, z, Blocks.log2);
    world.setBlock(x + 1, y + 10, z, Blocks.log2);
    world.setBlock(x + 1, y + 11, z, BlockRegister.BlockTronc);
    world.setBlock(x + 1, y + 12, z, Blocks.log2);
    world.setBlock(x - 1, y + 7, z, Blocks.log2);
    world.setBlock(x - 2, y + 8, z, Blocks.log2);
    world.setBlock(x - 3, y + 9, z, Blocks.log2);

    world.setBlock(x - 3, y + 10, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 10, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 5, y + 10, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 10, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 10, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 10, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 5, y + 10, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 10, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 10, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 3, y + 10, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 10, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 10, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 3, y + 10, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 3, y + 10, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 10, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 5, y + 10, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 10, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 10, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 3, y + 10, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 10, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 10, z - 2, BlockRegister.BlockFeuille);

    world.setBlock(x - 3, y + 11, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 11, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 11, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 3, y + 11, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 11, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 11, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 3, y + 11, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 11, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 4, y + 11, z + 1, BlockRegister.BlockFeuille);

    world.setBlock(x + 2, y + 12, z, BlockRegister.BlockFeuille);
    world.setBlock(x + 3, y + 12, z, BlockRegister.BlockFeuille);
    world.setBlock(x + 4, y + 12, z, BlockRegister.BlockFeuille);

    world.setBlock(x - 0, y + 12, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 12, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 12, z, BlockRegister.BlockFeuille);

    world.setBlock(x + 1, y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 12, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 12, z - 3, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 12, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 12, z + 3, BlockRegister.BlockFeuille);
    
  /**/
    world.setBlock(x + 2, y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 12, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 12, z + 3, BlockRegister.BlockFeuille);

    world.setBlock(x + 3, y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 3, y + 12, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x + 3, y + 12, z + 3, BlockRegister.BlockFeuille);
    
    world.setBlock(x + 4, y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 4, y + 12, z + 2, BlockRegister.BlockFeuille);
    
    world.setBlock(x + 2, y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 12, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 12, z - 3, BlockRegister.BlockFeuille);

    world.setBlock(x + 3, y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 3, y + 12, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x + 3, y + 12, z - 3, BlockRegister.BlockFeuille);
    
    world.setBlock(x + 4, y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 4, y + 12, z - 2, BlockRegister.BlockFeuille);
  
 /**/   
    world.setBlock(x , y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x , y + 12, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x , y + 12, z + 3, BlockRegister.BlockFeuille);

    world.setBlock(x - 1, y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 12, z + 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 12, z + 3, BlockRegister.BlockFeuille);
    
    world.setBlock(x - 2, y + 12, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 12, z + 2, BlockRegister.BlockFeuille);
    
    world.setBlock(x , y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x , y + 12, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x , y + 12, z - 3, BlockRegister.BlockFeuille);

    world.setBlock(x - 1, y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 12, z - 2, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 12, z - 3, BlockRegister.BlockFeuille);
    
    world.setBlock(x - 2, y + 12, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x - 2, y + 12, z - 2, BlockRegister.BlockFeuille);
    /**/
    
    world.setBlock(x + 1, y + 13, z, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 13, z, BlockRegister.BlockFeuille);
    world.setBlock(x + 3, y + 13, z, BlockRegister.BlockFeuille);
   
    world.setBlock(x + 1, y + 13, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 13, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 13, z - 2, BlockRegister.BlockFeuille);
    
    world.setBlock(x + 1, y + 13, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 2, y + 13, z + 1, BlockRegister.BlockFeuille);
    world.setBlock(x + 1, y + 13, z + 2, BlockRegister.BlockFeuille);
   
    world.setBlock(x, y + 13, z, BlockRegister.BlockFeuille);
    world.setBlock(x - 1, y + 13, z, BlockRegister.BlockFeuille);
    world.setBlock(x, y + 13, z - 1, BlockRegister.BlockFeuille);
    world.setBlock(x, y + 13, z + 1, BlockRegister.BlockFeuille);
    return true;
  }
}