package mod.common.world.structure;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;


public class Ruins extends WorldGenerator
{
	protected Block[] GetValidSpawnBlocks()
	{
		return new Block[]
		{
			Blocks.grass,
		};
	}

	public boolean LocationIsValidSpawn(World world, int x, int y, int z)
	{
		int distanceToAir = 0;
		Block checkBlock = world.getBlock(x, y, z);

		while (checkBlock != Blocks.air)
		{
			distanceToAir++;
			checkBlock = world.getBlock(x, y + distanceToAir, z);
		}

		if (distanceToAir > 1)
		{
			return false;
		}

		y += distanceToAir - 1;

		Block block = world.getBlock(x, y, z);
		Block blockAbove = world.getBlock(x, y + 1, z);
		Block blockBelow = world.getBlock(x, y - 1, z);

		for (Block i : GetValidSpawnBlocks())
		{
			if (blockAbove != Blocks.air)
			{
				return false;
			}
			if (block == i)
			{
				return true;
			}
			else if (block == Blocks.snow_layer && blockBelow == i)
			{
				return true;
			}
			else if (block.getMaterial() == Material.plants && blockBelow == i)
			{
				return true;
			}
		}
		return false;
	}

	public boolean generate(World world, Random rand, int x, int y, int z)
	{
		int i = rand.nextInt(1);

		if(i == 0)
		{
		    generate_r0(world, rand, x, y, z);
		}

       return true;

	}

	public boolean generate_r0(World world, Random rand, int x, int y, int z)
	{
		if(!LocationIsValidSpawn(world, x, y, z) || !LocationIsValidSpawn(world, x + 11, y, z) || !LocationIsValidSpawn(world, x + 11, y, z + 11) || !LocationIsValidSpawn(world, x, y, z + 11))
		{
			return false;
		}

		world.setBlock(x + 0, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 0, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 0, z + 2, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 7, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 3, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 4, y + 0, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 0, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 0, z + 3, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 7, y + 0, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 0, z + 3, Blocks.coal_block, 0, 3);
		world.setBlock(x + 9, y + 0, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 4, Blocks.coal_block, 0, 3);
		world.setBlock(x + 4, y + 0, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 0, z + 4, Blocks.dirt, 0, 3);
		world.setBlock(x + 6, y + 0, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 0, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 0, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 0, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 5, Blocks.stone_slab, 11, 3);
		world.setBlock(x + 3, y + 0, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 0, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 5, y + 0, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 6, y + 0, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 0, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 8, y + 0, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 9, y + 0, z + 5, Blocks.coal_block, 0, 3);
		world.setBlock(x + 10, y + 0, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 6, Blocks.stone_slab, 11, 3);
		world.setBlock(x + 3, y + 0, z + 6, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 4, y + 0, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 0, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 6, y + 0, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 0, z + 6, Blocks.dirt, 0, 3);
		world.setBlock(x + 8, y + 0, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 0, z + 6, Blocks.coal_block, 0, 3);
		world.setBlock(x + 10, y + 0, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 7, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 4, y + 0, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 0, z + 7, Blocks.netherrack, 0, 3);
		world.setBlock(x + 6, y + 0, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 0, z + 7, Blocks.dirt, 0, 3);
		world.setBlock(x + 8, y + 0, z + 7, Blocks.coal_block, 0, 3);
		world.setBlock(x + 9, y + 0, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 8, Blocks.coal_block, 0, 3);
		world.setBlock(x + 4, y + 0, z + 8, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 5, y + 0, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 0, z + 8, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 7, y + 0, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 0, z + 8, Blocks.dirt, 0, 3);
		world.setBlock(x + 9, y + 0, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 0, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 0, z + 9, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 7, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 0, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 1, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 2, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 9, y + 1, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 1, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 3, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 3, y + 1, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 1, z + 3, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 1, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 1, z + 4, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 1, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 5, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 3, y + 1, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 1, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 1, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 1, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 1, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 7, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 3, y + 1, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 1, z + 7, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 1, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 8, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 3, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 1, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 1, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 1, z + 9, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 4, y + 1, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 1, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 1, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 1, z + 9, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 8, y + 1, z + 9, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 9, y + 1, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 1, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 1, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 2, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 1, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 2, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 2, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 3, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 2, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 2, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 2, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 11, y + 2, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 2, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 2, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 11, y + 2, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 6, Blocks.coal_block, 0, 3);
		world.setBlock(x + 2, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 2, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 11, y + 2, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 7, Blocks.stone_slab, 11, 3);
		world.setBlock(x + 2, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 2, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 11, y + 2, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 8, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 3, y + 2, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 2, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 8, Blocks.dirt, 0, 3);
		world.setBlock(x + 10, y + 2, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 2, z + 9, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 4, y + 2, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 2, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 2, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 2, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 9, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 9, y + 2, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 2, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 2, z + 10, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 5, y + 2, z + 10, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 6, y + 2, z + 10, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 7, y + 2, z + 10, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 2, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 3, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 1, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 1, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 1, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 3, z + 2, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 4, y + 3, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 2, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 2, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 10, y + 3, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 3, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 3, y + 3, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 3, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 10, y + 3, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 4, Blocks.gravel, 0, 3);
		world.setBlock(x + 2, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 3, z + 4, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 11, y + 3, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 2, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 3, z + 5, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 11, y + 3, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 2, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 3, z + 6, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 11, y + 3, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 7, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 2, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 3, z + 7, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 11, y + 3, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 8, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 10, y + 3, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 9, Blocks.stone_slab, 11, 3);
		world.setBlock(x + 3, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 3, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 3, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 3, z + 10, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 3, z + 10, Blocks.stone_slab, 3, 3);
		world.setBlock(x + 6, y + 3, z + 10, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 3, z + 10, Blocks.stone_slab, 3, 3);
		world.setBlock(x + 8, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 3, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 4, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 1, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 7, y + 4, z + 1, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 2, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 3, y + 4, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 2, Blocks.netherrack, 0, 3);
		world.setBlock(x + 10, y + 4, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 3, Blocks.netherrack, 0, 3);
		world.setBlock(x + 3, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 4, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 4, Blocks.coal_block, 0, 3);
		world.setBlock(x + 2, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 4, z + 4, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 11, y + 4, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 2, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 4, z + 5, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 11, y + 4, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 6, Blocks.gravel, 0, 3);
		world.setBlock(x + 2, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 4, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 11, y + 4, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 7, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 2, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 4, z + 7, Blocks.netherrack, 0, 3);
		world.setBlock(x + 11, y + 4, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 4, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 4, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 9, Blocks.coal_block, 0, 3);
		world.setBlock(x + 3, y + 4, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 4, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 4, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 4, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 9, Blocks.netherrack, 0, 3);
		world.setBlock(x + 9, y + 4, z + 9, Blocks.stone_slab, 3, 3);
		world.setBlock(x + 10, y + 4, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 4, z + 10, Blocks.coal_block, 0, 3);
		world.setBlock(x + 5, y + 4, z + 10, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 4, z + 10, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 7, y + 4, z + 10, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 4, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 5, z + 1, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 1, Blocks.netherrack, 0, 3);
		world.setBlock(x + 6, y + 5, z + 1, Blocks.cobblestone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 1, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 5, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 2, Blocks.fire, 5, 3);
		world.setBlock(x + 10, y + 5, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 5, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 4, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 2, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 5, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 11, y + 5, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 5, Blocks.fire, 3, 3);
		world.setBlock(x + 2, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 5, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 11, y + 5, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 6, Blocks.coal_block, 0, 3);
		world.setBlock(x + 2, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 5, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 11, y + 5, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 7, Blocks.gravel, 0, 3);
		world.setBlock(x + 2, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 5, z + 7, Blocks.fire, 1, 3);
		world.setBlock(x + 11, y + 5, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 5, z + 8, Blocks.dirt, 0, 3);
		world.setBlock(x + 10, y + 5, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 5, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 5, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 5, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 5, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 5, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 9, Blocks.fire, 1, 3);
		world.setBlock(x + 9, y + 5, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 5, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 5, z + 10, Blocks.netherrack, 0, 3);
		world.setBlock(x + 5, y + 5, z + 10, Blocks.dirt, 2, 3);
		world.setBlock(x + 6, y + 5, z + 10, Blocks.netherrack, 0, 3);
		world.setBlock(x + 7, y + 5, z + 10, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 8, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 5, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 6, z + 1, Blocks.fire, 15, 3);
		world.setBlock(x + 6, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 6, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 2, Blocks.dirt, 0, 3);
		world.setBlock(x + 8, y + 6, z + 2, Blocks.dirt, 2, 3);
		world.setBlock(x + 9, y + 6, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 6, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 6, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 6, z + 3, Blocks.netherrack, 0, 3);
		world.setBlock(x + 10, y + 6, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 4, Blocks.gravel, 0, 3);
		world.setBlock(x + 3, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 6, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 6, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 3, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 6, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 6, z + 5, Blocks.fire, 15, 3);
		world.setBlock(x + 11, y + 6, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 6, Blocks.coal_block, 0, 3);
		world.setBlock(x + 3, y + 6, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 6, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 6, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 6, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 7, Blocks.netherrack, 0, 3);
		world.setBlock(x + 3, y + 6, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 6, z + 7, Blocks.gravel, 0, 3);
		world.setBlock(x + 9, y + 6, z + 7, Blocks.stone_slab, 3, 3);
		world.setBlock(x + 10, y + 6, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 8, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 3, y + 6, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 6, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 6, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 6, z + 8, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 10, y + 6, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 6, z + 9, Blocks.netherrack, 0, 3);
		world.setBlock(x + 4, y + 6, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 6, z + 9, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 6, y + 6, z + 9, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 6, z + 9, Blocks.netherrack, 0, 3);
		world.setBlock(x + 8, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 6, z + 10, Blocks.fire, 15, 3);
		world.setBlock(x + 5, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 6, z + 10, Blocks.fire, 15, 3);
		world.setBlock(x + 7, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 6, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 7, z + 2, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 7, z + 2, Blocks.netherrack, 0, 3);
		world.setBlock(x + 7, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 3, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 7, z + 3, Blocks.gravel, 0, 3);
		world.setBlock(x + 5, y + 7, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 7, z + 3, Blocks.gravel, 0, 3);
		world.setBlock(x + 7, y + 7, z + 3, Blocks.dirt, 2, 3);
		world.setBlock(x + 8, y + 7, z + 3, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 9, y + 7, z + 3, Blocks.fire, 15, 3);
		world.setBlock(x + 10, y + 7, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 7, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 7, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 7, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 7, z + 4, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 7, z + 4, Blocks.gravel, 0, 3);
		world.setBlock(x + 9, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 5, Blocks.fire, 15, 3);
		world.setBlock(x + 3, y + 7, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 4, y + 7, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 7, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 7, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 7, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 7, z + 5, Blocks.netherrack, 0, 3);
		world.setBlock(x + 9, y + 7, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 10, y + 7, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 3, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 7, z + 6, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 7, z + 6, Blocks.stonebrick, 1, 3);
		world.setBlock(x + 10, y + 7, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 7, Blocks.fire, 15, 3);
		world.setBlock(x + 3, y + 7, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 7, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 7, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 7, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 7, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 7, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 9, y + 7, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 4, y + 7, z + 8, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 5, y + 7, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 6, y + 7, z + 8, Blocks.dirt, 2, 3);
		world.setBlock(x + 7, y + 7, z + 8, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 7, z + 8, Blocks.netherrack, 0, 3);
		world.setBlock(x + 9, y + 7, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 9, Blocks.fire, 15, 3);
		world.setBlock(x + 4, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 7, z + 9, Blocks.dirt, 2, 3);
		world.setBlock(x + 6, y + 7, z + 9, Blocks.stone, 0, 3);
		world.setBlock(x + 7, y + 7, z + 9, Blocks.fire, 15, 3);
		world.setBlock(x + 8, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 7, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 2, Blocks.fire, 15, 3);
		world.setBlock(x + 7, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 4, Blocks.netherrack, 0, 3);
		world.setBlock(x + 5, y + 8, z + 4, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 6, y + 8, z + 4, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 7, y + 8, z + 4, Blocks.dirt, 2, 3);
		world.setBlock(x + 8, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 5, Blocks.fire, 15, 3);
		world.setBlock(x + 4, y + 8, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 5, y + 8, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 6, y + 8, z + 5, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 8, z + 5, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 8, z + 5, Blocks.fire, 15, 3);
		world.setBlock(x + 9, y + 8, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 6, Blocks.coal_block, 0, 3);
		world.setBlock(x + 5, y + 8, z + 6, Blocks.dirt, 2, 3);
		world.setBlock(x + 6, y + 8, z + 6, Blocks.mossy_cobblestone, 0, 3);
		world.setBlock(x + 7, y + 8, z + 6, Blocks.netherrack, 0, 3);
		world.setBlock(x + 8, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 7, Blocks.netherrack, 0, 3);
		world.setBlock(x + 5, y + 8, z + 7, Blocks.packed_ice, 0, 3);
		world.setBlock(x + 6, y + 8, z + 7, Blocks.coal_block, 0, 3);
		world.setBlock(x + 7, y + 8, z + 7, Blocks.stone, 0, 3);
		world.setBlock(x + 8, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 8, Blocks.fire, 15, 3);
		world.setBlock(x + 9, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 8, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 0, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 1, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 2, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 3, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 4, Blocks.fire, 15, 3);
		world.setBlock(x + 5, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 4, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 5, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 6, Blocks.fire, 15, 3);
		world.setBlock(x + 8, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 6, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 7, Blocks.fire, 0, 3);
		world.setBlock(x + 5, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 7, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 8, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 9, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 10, Blocks.air, 0, 3);
		world.setBlock(x + 0, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 1, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 2, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 3, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 4, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 5, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 6, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 7, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 8, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 9, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 10, y + 9, z + 11, Blocks.air, 0, 3);
		world.setBlock(x + 11, y + 9, z + 11, Blocks.air, 0, 3);
		return true;

	}

}