package mod.common.world.biome;

import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBase.SpawnListEntry;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;

public class AncientBiome extends BiomeGenBase
{
  public AncientBiome(int par1)
  {
    super(par1);
    setTemperatureRainfall(0.0F, 0.0F);
    setHeight(height_LowPlains);
    this.theBiomeDecorator.treesPerChunk = -999;
    this.theBiomeDecorator.flowersPerChunk = 4;
    this.theBiomeDecorator.grassPerChunk = 10;
    this.flowers.clear();

    
  }
  

  public String func_150572_a(Random p_150572_1_, int p_150572_2_, int p_150572_3_, int p_150572_4_)
  {
    double d0 = plantNoise.func_151601_a(p_150572_2_ / 200.0D, p_150572_4_ / 200.0D);

    if (d0 < -0.8D)
    {
      int l = p_150572_1_.nextInt(4);
      return net.minecraft.block.BlockFlower.field_149859_a[(4 + l)];
    }
    if (p_150572_1_.nextInt(3) > 0)
    {
      int l = p_150572_1_.nextInt(3);
      return l == 1 ? net.minecraft.block.BlockFlower.field_149859_a[3] : l == 0 ? net.minecraft.block.BlockFlower.field_149859_a[0] : net.minecraft.block.BlockFlower.field_149859_a[8];
    }

    return net.minecraft.block.BlockFlower.field_149858_b[0];
  }

  public void decorate(World par1World, Random par2Random, int par3, int par4)
  {
    double d0 = plantNoise.func_151601_a((par3 + 8) / 200.0D, (par4 + 8) / 200.0D);

    if (d0 < -0.8D)
    {
      this.theBiomeDecorator.flowersPerChunk = 15;
      this.theBiomeDecorator.grassPerChunk = 5;
    }
    else
    {
      this.theBiomeDecorator.flowersPerChunk = 4;
      this.theBiomeDecorator.grassPerChunk = 10;
      flowers.func_150548_a(2);

      for (int k = 0; k < 7; k++)
      {
        int l = par3 + par2Random.nextInt(16) + 8;
        int i1 = par4 + par2Random.nextInt(16) + 8;
        int j1 = par2Random.nextInt(par1World.getHeightValue(l, i1) + 32);
        flowers.generate(par1World, par2Random, l, j1, i1);
      }

    }

    super.decorate(par1World, par2Random, par3, par4);
  }

  public BiomeGenBase createMutation()
  {
    BiomeGenPlains biomegenplains = new BiomeGenPlains(this.biomeID + 128);
    biomegenplains.setBiomeName("Sunflower Plains");
    biomegenplains.setColor(9286496);
    biomegenplains.field_150609_ah = 14273354;
    return biomegenplains;
  }
  
  @Override public int getModdedBiomeGrassColor(int original) 
  { 
	  BiomeEvent.GetGrassColor event = new BiomeEvent.GetGrassColor(this, 0xCC9900); 
	  MinecraftForge.EVENT_BUS.post(event); return event.newColor; 
  }
  
  @Override public int getModdedBiomeFoliageColor(int original) 
  { 
	  BiomeEvent.GetFoliageColor event = new BiomeEvent.GetFoliageColor(this, 0xCC9900); 
	  MinecraftForge.EVENT_BUS.post(event); return event.newColor; 
  }
  
  
  
}