package mod.common.recipes;

import mod.common.block.BlockRegister;
import mod.common.block.entity.TileEntityCouveuse;
import mod.common.block.entity.TileEntityExtractor;
import mod.common.item.ItemRegister;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ExtractorSimpleRecipe implements IExtractorRecipe
{

    public static final Item[] matrix = new Item[] 
    		{
            ItemRegister.itemSapwithmosquito
            }; 

    @Override
    public boolean matches(TileEntityExtractor tile, World world) 
    {
        for (int i = 0; i < 1; i++) 
        { 
            if (!ExtractorSimpleRecipe.corresponds(ExtractorSimpleRecipe.matrix[i], tile.getStackInSlot(i))) return false; 
        }
        
        return true; 
    }

    @Override
    public ItemStack getOutput(TileEntityExtractor tile, World world) 
    {
        return new ItemStack(ItemRegister.itemBloodofmosquito); 
    }

    public static boolean corresponds(Item item, ItemStack stack) 
    {
        if (stack == null && item == null) return true;
        if (stack == null && item != null) return false;
        if (stack != null && item == null) return false;
        if (stack.getItem() != item) return false;

        return true;
        
        
    }
    
}
