package mod.common.recipes;

import java.util.ArrayList;
import java.util.ListIterator;

import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.block.entity.TileEntityExtractor;
import net.minecraft.item.ItemStack;

public class ExtractorRecipes 
{
	 private static ArrayList<IExtractorRecipe> recipes = new ArrayList<IExtractorRecipe>();
	    
	    /**
	     * @param stacks tile content
	     * @return the recipe output
	     */
	    public static ItemStack getOutput(TileEntityExtractor tile, ItemStack ... stacks) {
	        ListIterator<IExtractorRecipe> ite = recipes.listIterator();
	        while (ite.hasNext()) {
	            IExtractorRecipe r = ite.next();
	            if (r.matches(tile, tile.getWorld())) return r.getOutput(tile, tile.getWorld()); 
	        }
	        return null;
	    }
	    
	    /**
	     * @return the recipe map
	     */
	    public static ArrayList<IExtractorRecipe> getRecipes() {
	        return recipes; 
	    }
	    
	    /**
	     * init your recipes (called from your main class)
	     */
	    public static void initRecipes()
	    {
	        ExtractorRecipes.addRecipe(new ExtractorSimpleRecipe()); 
	        ExtractorRecipes.addRecipe(new ExtractorAmbreRecipe()); 

	    }
	    
	    /**
	     * @param recipe
	     */
	    public static void addRecipe(IExtractorRecipe recipe) {
	        recipes.add(recipe);
	    }
	    
	    /**
	     * @param stack first stack
	     * @param stack1 second stack
	     * @return true if the 2 stacks are equals
	     */
	    public static boolean corresponds(ItemStack stack, ItemStack stack1) {
	        if (stack == null && stack1 == null) return true;
	        if (stack == null && stack1 != null) return false;
	        if (stack != null && stack1 == null) return false;
	        if (stack.getItem() != stack1.getItem()) return false;
	        if (stack.getItemDamage() != stack1.getItemDamage()) return false;
	        return true;
	    }
}
