package mod.common.recipes;

import mod.DinoCraft;
import mod.common.block.BlockRegister;
import mod.common.block.entity.TileEntityCouveuse;
import mod.common.entity.EntityTriceratops;
import mod.common.entity.EntityVelociraptors;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CouveuseSimpleRecipe4  implements ICouveuseRecipe
{

    public static final ItemStack[] matrix = new ItemStack[] 
    		{
            new ItemStack(BlockRegister.BlockEgg, 1, 3)
            }; 
    

    @Override
    public boolean matches(TileEntityCouveuse tile, World world)
    {  
    	return CouveuseRecipes.corresponds(matrix[0], tile.getStackInSlot(0));
    }

    

  
    
    @Override
    public ItemStack getOutput(TileEntityCouveuse tile, World world) 
    {
    	int id = DinoCraft.maptoid.get(EntityVelociraptors.class);
        return new ItemStack(Items.spawn_egg, 1, id); 
        
    }

    public static boolean corresponds(Block block, ItemStack stack) 
    {
        if (stack == null && block == null) return true;
        if (stack == null && block != null) return false;
        if (stack != null && block == null) return false;
        if (stack.getItem() != Item.getItemFromBlock(block)) return false;

        return true;
        
        
    }
    
}