package mod.common.recipes;

import java.util.HashMap;

import org.lwjgl.opengl.GL11;

import mod.DinoCraft;
import mod.client.model.ModelCouveuse;
import mod.common.block.BlockRegister;
import mod.common.block.entity.TileEntityCouveuse;
import mod.common.entity.EntityBrachiosaurus;
import mod.common.entity.EntityFrog;
import mod.common.entity.EntityRegister;
import mod.common.item.ItemRegister;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CouveuseSimpleRecipe implements ICouveuseRecipe
{

    public static final ItemStack[] matrix = new ItemStack[] 
    		{
            new ItemStack(BlockRegister.BlockEgg, 1)
            }; 
    

    @Override
    public boolean matches(TileEntityCouveuse tile, World world)
    {  
    	return CouveuseRecipes.corresponds(matrix[0], tile.getStackInSlot(0));
    }

    

  
    
    @Override
    public ItemStack getOutput(TileEntityCouveuse tile, World world) 
    {
    	int id = DinoCraft.maptoid.get(EntityBrachiosaurus.class);
        return new ItemStack(Items.spawn_egg, 1, id); 
        
    }

    public static boolean corresponds(Block block, ItemStack stack) 
    {
        if (stack == null && block == null) return true;
        if (stack == null && block != null) return false;
        if (stack != null && block == null) return false;
        if (stack.getItem() != Item.getItemFromBlock(block)) return false;

        return true;
        
        
    }
    
}
 