package mod.common.recipes;

import java.util.ArrayList;
import java.util.ListIterator;

import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.block.entity.TileEntityCouveuse;
import net.minecraft.item.ItemStack;

public class CouveuseRecipes 
{
private static ArrayList<ICouveuseRecipe> recipes = new ArrayList<ICouveuseRecipe>();

/**
 * @param stacks tile content
 * @return the recipe output
 */
public static ItemStack getOutput(TileEntityCouveuse tile, ItemStack ... stacks) {
    ListIterator<ICouveuseRecipe> ite = recipes.listIterator();
  
    while (ite.hasNext()) 
    {
    	ICouveuseRecipe r = ite.next();
        if (r.matches(tile, tile.getWorld())) return r.getOutput(tile, tile.getWorld()); 
    }
    return null;
}

/**
 * @return the recipe map
 */
public static ArrayList<ICouveuseRecipe> getRecipes() {
    return recipes; 
}

/**
 * init your recipes (called from your main class)
 */
public static void initRecipes() {
    CouveuseRecipes.addRecipe(new CouveuseSimpleRecipe()); 
    CouveuseRecipes.addRecipe(new CouveuseSimpleRecipe2());
    CouveuseRecipes.addRecipe(new CouveuseSimpleRecipe3()); 
    CouveuseRecipes.addRecipe(new CouveuseSimpleRecipe4()); 


}

/**
 * @param recipe
 */
public static void addRecipe(ICouveuseRecipe recipe) {
    recipes.add(recipe);
}

/**
 * @param stack first stack
 * @param stack1 second stack
 * @return true if the 2 stacks are equals
 */
public static boolean corresponds(ItemStack stack, ItemStack stack1) {
    if (stack == null && stack1 == null) return true;
    if (stack == null && stack1 != null) return false;
    if (stack != null && stack1 == null) return false;
    if (stack.getItem() != stack1.getItem()) return false;
    if (stack.getItemDamage() != stack1.getItemDamage()) return false;
    return true;
}
}