package mod.common.recipes;

import java.util.Random;

import mod.common.block.BlockRegister;
import mod.common.block.entity.TileEntityCombiner;
import mod.common.item.ItemRegister;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CombinerSimpleRecipeSpecial implements ICombinerRecipe
{
	public static final Random r = new Random();
    public static final Item[] matrix = new Item[] 
    		{
            ItemRegister.itemADNofvelociraptors,
            ItemRegister.itemADNofFrog,
            Items.egg
    		}; 


    @Override
    public boolean matches(TileEntityCombiner tile, World world) 
    {
        for (int i = 0; i < 3; i++) 
        { 
            if (!CombinerSimpleRecipeSpecial.corresponds(CombinerSimpleRecipeSpecial.matrix[i], tile.getStackInSlot(i))) return false;
        }
        return true; 
    }
    
    

    @Override
    public ItemStack getOutput(TileEntityCombiner tile, World world) 
    {
    	
        return new ItemStack(BlockRegister.BlockEggIndominus, 1); 
        
   
    }
    

    public static boolean corresponds(Item item, ItemStack stack) {
        if (stack == null && item == null) return true;
        if (stack == null && item != null) return false;
        if (stack != null && item == null) return false;
        if (stack.getItem() != item) return false;
        return true;
    }
}