package mod.common.recipes;

import java.util.ArrayList;
import java.util.ListIterator;

import mod.common.block.entity.TileEntityCombiner;
import net.minecraft.item.ItemStack;

public class CombinerRecipes 
{
	  private static ArrayList<ICombinerRecipe> recipes = new ArrayList<ICombinerRecipe>();
	    
	    /**
	     * @param stacks tile content
	     * @return the recipe output
	     */
	    public static ItemStack getOutput(TileEntityCombiner tile, ItemStack ... stacks) {
	        ListIterator<ICombinerRecipe> ite = recipes.listIterator();
	        while (ite.hasNext()) {
	            ICombinerRecipe r = ite.next();
	            if (r.matches(tile, tile.getWorld())) return r.getOutput(tile, tile.getWorld()); 
	        }
	        return null;
	    }
	    
	    /**
	     * @return the recipe map
	     */
	    public static ArrayList<ICombinerRecipe> getRecipes() {
	        return recipes; 
	    }
	    
	    /**
	     * init your recipes (called from your main class)
	     */
	    public static void initRecipes() {
	        CombinerRecipes.addRecipe(new CombinerSimpleRecipe()); 
	        CombinerRecipes.addRecipe(new CombinerSimpleRecipeSpecial()); 

	    }
	    
	    /**
	     * @param recipe
	     */
	    public static void addRecipe(ICombinerRecipe recipe) {
	        recipes.add(recipe);
	    }
	    
	    /**
	     * @param stack first stack
	     * @param stack1 second stack
	     * @return true if the 2 stacks are equals
	     */
	    public static boolean corresponds(ItemStack stack, ItemStack stack1) {
	        if (stack == null && stack1 == null) return true;
	        if (stack == null && stack1 != null) return false;
	        if (stack != null && stack1 == null) return false;
	        if (stack.getItem() != stack1.getItem()) return false;
	        if (stack.getItemDamage() != stack1.getItemDamage()) return false;
	        return true;
	    }
}
