package mod.common.recipes;

import java.util.Random;

import mod.common.block.BlockRegister;
import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.item.ItemRegister;
import net.minecraft.block.BlockColored;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AnalyzerSimpleRecipe implements IAnalyzerRecipe
{
    public static final Random r = new Random();
    
    public static final Item[] matrix = new Item[] 
    		{
            ItemRegister.itemBloodofmosquito
    		}; 


    @Override
    public boolean matches(TileEntityAnalyzer tile, World world) 
    {
        for (int i = 0; i < 1; i++) 
        { 
            if (!AnalyzerSimpleRecipe.corresponds(AnalyzerSimpleRecipe.matrix[i], tile.getStackInSlot(i))) return false;
        }
        return true; 
    }
    
    

    @Override
    public ItemStack getOutput(TileEntityAnalyzer tile, World world) {
        return new ItemStack(ItemRegister.itemADNofmosquito); 
        
   
    }
    

    public static boolean corresponds(Item item, ItemStack stack) {
        if (stack == null && item == null) return true;
        if (stack == null && item != null) return false;
        if (stack != null && item == null) return false;
        if (stack.getItem() != item) return false;
        return true;
    }
}