package mod.common.recipes;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import mod.common.block.entity.TileEntityAnalyzer;
import net.minecraft.item.ItemStack;

public class AnalyzerRecipes
{
    private static ArrayList<IAnalyzerRecipe> recipes = new ArrayList<IAnalyzerRecipe>();
    
    /**
     * @param stacks tile content
     * @return the recipe output
     */
    public static ItemStack getOutput(TileEntityAnalyzer tile, ItemStack ... stacks) {
        ListIterator<IAnalyzerRecipe> ite = recipes.listIterator();
        while (ite.hasNext()) {
            IAnalyzerRecipe r = ite.next();
            if (r.matches(tile, tile.getWorld())) return r.getOutput(tile, tile.getWorld()); 
        }
        return null;
    }
    
    /**
     * @return the recipe map
     */
    public static ArrayList<IAnalyzerRecipe> getRecipes() {
        return recipes; 
    }
    
    /**
     * init your recipes (called from your main class)
     */
    public static void initRecipes()
    {
        AnalyzerRecipes.addRecipe(new AnalyzerSimpleRecipe()); 
        AnalyzerRecipes.addRecipe(new AnalyzerFrogRecipe());
        AnalyzerRecipes.addRecipe(new AnalyzerSimpleRecipe2());

    }
    
    /**
     * @param recipe
     */
    public static void addRecipe(IAnalyzerRecipe recipe) {
        recipes.add(recipe);
    }
    
    /**
     * @param stack first stack
     * @param stack1 second stack
     * @return true if the 2 stacks are equals
     */
    public static boolean corresponds(ItemStack stack, ItemStack stack1) {
        if (stack == null && stack1 == null) return true;
        if (stack == null && stack1 != null) return false;
        if (stack != null && stack1 == null) return false;
        if (stack.getItem() != stack1.getItem()) return false;
        if (stack.getItemDamage() != stack1.getItemDamage()) return false;
        return true;
    }
}
 

