package mod.common.recipes;

import java.util.Random;

import mod.common.block.BlockRegister;
import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.item.ItemRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AnalyzerFrogRecipe implements IAnalyzerRecipe
{
    
    public static final Item[] matrix = new Item[] 
    		{
          	ItemRegister.itemSyringewithblood
    		}; 


    @Override
    public boolean matches(TileEntityAnalyzer tile, World world) {
        for (int i = 0; i < 1; i++) { 
            if (!AnalyzerFrogRecipe.corresponds(AnalyzerFrogRecipe.matrix[i], tile.getStackInSlot(i))) return false;
        }
        return true; 
    }
    
    

    @Override
    public ItemStack getOutput(TileEntityAnalyzer tile, World world) {
        return new ItemStack(ItemRegister.itemADNofFrog); 
        
   
    }
    

    public static boolean corresponds(Item item, ItemStack stack) {
        if (stack == null && item == null) return true;
        if (stack == null && item != null) return false;
        if (stack != null && item == null) return false;
        if (stack.getItem() != item) return false;
        return true;
    }
}