package mod.common.item;

import mod.DinoCraft;
import mod.common.entity.EntityFlechette;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;


public class ItemBlowGun extends Item
{

  public ItemBlowGun()
  {
    this.maxStackSize = 1;
    this.setMaxDamage(38444);
    this.setCreativeTab(CreativeTabs.tabCombat);
    this.setUnlocalizedName("itemBlowgun");
  }

  public void onPlayerStoppedUsing(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4)
  {
    int j = getMaxItemUseDuration(par1ItemStack) - par4;

    ArrowLooseEvent event = new ArrowLooseEvent(par3EntityPlayer, par1ItemStack, j);
    MinecraftForge.EVENT_BUS.post(event);
    if (event.isCanceled())
    {
      return;
    }
    j = event.charge;

    boolean flag = (par3EntityPlayer.capabilities.isCreativeMode) || (EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, par1ItemStack) > 0);

    if ((flag) || (par3EntityPlayer.inventory.hasItem(ItemRegister.itemDart)))
    {
      float f = j / 20.0F;
      f = (f * f + f * 2.0F) / 3.0F;

      if (f < 0.1D)
      {
        return;
      }

      if (f > 1.0F)
      {
        f = 1.0F;
      }

      EntityFlechette entityflechette = new EntityFlechette(par2World, par3EntityPlayer, f * 2.0F);

      if (f == 1.0F)
      {
        entityflechette.setIsCritical(true);
      }

      par1ItemStack.damageItem(1, par3EntityPlayer);
      par2World.playSoundAtEntity(par3EntityPlayer, "random.bow", 1.0F, 1.0F / (itemRand.nextFloat() * 0.4F + 1.2F) + f * 0.5F);

      if (flag)
      {
        entityflechette.canBePickedUp = 2;
      }
      else
      {
        par3EntityPlayer.inventory.consumeInventoryItem(ItemRegister.itemDart);
      }

      if (!par2World.isRemote)
      {
        par2World.spawnEntityInWorld(entityflechette);
      }
    }
  }

  public ItemStack onEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
  {
    return par1ItemStack;
  }

  public int getMaxItemUseDuration(ItemStack par1ItemStack)
  {
    return 72000;
  }

  public EnumAction getItemUseAction(ItemStack par1ItemStack)
  {
    return EnumAction.BOW;
  }

  public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
  {
    ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, par1ItemStack);
    MinecraftForge.EVENT_BUS.post(event);
    if (event.isCanceled())
    {
      return event.result;
    }

    if ((par3EntityPlayer.capabilities.isCreativeMode) || (par3EntityPlayer.inventory.hasItem(ItemRegister.itemDart)))
    {
      par3EntityPlayer.setItemInUse(par1ItemStack, getMaxItemUseDuration(par1ItemStack));
    }

    return par1ItemStack;
  }


}