package mod.common.entity;

import mod.common.item.ItemRegister;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityVelociraptors extends EntityMob
{
	  public EntityVelociraptors(World world)
	  {
	    super(world);
	  }

	  public void applyEntityAttributes()
	  {
	    super.applyEntityAttributes();
	    getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(120.0D);
	    getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(20.0D);
	    getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(100.0D);
	    getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(10.0D);
	    setSize(3.0F, 3.0F);
	  }
	  
	  public boolean interact(EntityPlayer player)
	  {
	    ItemStack itemstack = player.inventory.getCurrentItem();
	    boolean flag = (itemstack != null) && (itemstack.getItem() == Items.spawn_egg);

	    if ((!flag) && (isEntityAlive()) && (!player.isSneaking()) && (itemstack != null) && (itemstack.getItem() == ItemRegister.itemSyringe))
	    {
	      if (!this.worldObj.isRemote)
	      {
	        player.dropPlayerItemWithRandomChoice(new ItemStack(ItemRegister.itemSyringewithraptorblood), false);
	        player.destroyCurrentEquippedItem();
	      }

	      return true;
	    }

	    return super.interact(player);
	  }
	}