package mod.common.entity;

import mod.common.item.ItemRegister;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityFrog extends EntityAmbientCreature
{
  public EntityFrog(World par1World)
  {
    super(par1World);
  }

  public void onUpdate() {
    super.onUpdate();

    if ((this.worldObj.getTotalWorldTime() % 80L == 0L) && 
      (this.onGround))
      jump();
  }
  
  public void applyEntityAttributes()
  {
	  super.applyEntityAttributes();
	  setSize(1F, 1F);
  }
  

  protected void jump()
  {
    this.motionY = 0.4199999868869782D;

    if (isPotionActive(Potion.jump))
    {
      this.motionY += (getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.1F;
    }

    float f = this.rotationYaw * 0.01745329F;
    this.motionX -= MathHelper.sin(f) * 0.5F;
    this.motionZ += MathHelper.cos(f) * 0.5F;

    this.isAirBorne = true;
    ForgeHooks.onLivingJump(this);
  }

  public Item getDropItem() {
    return ItemRegister.itemFrogLegs;
  }

  public boolean interact(EntityPlayer player)
  {
    ItemStack itemstack = player.inventory.getCurrentItem();
    boolean flag = (itemstack != null) && (itemstack.getItem() == Items.spawn_egg);

    if ((!flag) && (isEntityAlive()) && (!player.isSneaking()) && (itemstack != null) && (itemstack.getItem() == ItemRegister.itemSyringe))
    {
      if (!this.worldObj.isRemote)
      {
        player.dropPlayerItemWithRandomChoice(new ItemStack(ItemRegister.itemSyringewithblood), false);
        player.destroyCurrentEquippedItem();
      }

      return true;
    }

    return super.interact(player);
  }
}