package mod.common.entity;

import java.util.List;

import mod.common.item.ItemRegister;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;


public class EntityFlechette extends Entity implements IProjectile
{
	private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private boolean inGround;
    /** 1 if the player can pick up the arrow */
    public int canBePickedUp;
    /** Seems to be some sort of timer for animating an arrow. */
    public int arrowShake;
    /** The owner of this arrow. */
    public Entity shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 2.0D;
    /** The amount of knockback an arrow applies when it hits a mob. */
    private int knockbackStrength;

  public EntityFlechette(World par1World)
  {
    super(par1World);
    this.renderDistanceWeight = 10.0D;
    setSize(0.5F, 0.5F);
  }

  public EntityFlechette(World par1World, double par2, double par4, double par6)
  {
    super(par1World);
    this.renderDistanceWeight = 10.0D;
    setSize(0.5F, 0.5F);
    setPosition(par2, par4, par6);
  }

  public EntityFlechette(World worldIn, EntityLivingBase shooter, EntityLivingBase p_i1755_3_, float p_i1755_4_, float p_i1755_5_)
  {
      super(worldIn);
      this.renderDistanceWeight = 10.0D;
      this.shootingEntity = shooter;

      if (shooter instanceof EntityPlayer)
      {
          this.canBePickedUp = 1;
      }

      this.posY = shooter.posY + (double)shooter.getEyeHeight() - 0.10000000149011612D;
      double d0 = p_i1755_3_.posX - shooter.posX;
      double d1 = p_i1755_3_.getEntityBoundingBox().minY + (double)(p_i1755_3_.height / 3.0F) - this.posY;
      double d2 = p_i1755_3_.posZ - shooter.posZ;
      double d3 = (double)MathHelper.sqrt_double(d0 * d0 + d2 * d2);

      if (d3 >= 1.0E-7D)
      {
          float f2 = (float)(Math.atan2(d2, d0) * 180.0D / Math.PI) - 90.0F;
          float f3 = (float)(-(Math.atan2(d1, d3) * 180.0D / Math.PI));
          double d4 = d0 / d3;
          double d5 = d2 / d3;
          this.setLocationAndAngles(shooter.posX + d4, this.posY, shooter.posZ + d5, f2, f3);
          float f4 = (float)(d3 * 0.20000000298023224D);
          this.setThrowableHeading(d0, d1 + (double)f4, d2, p_i1755_4_, p_i1755_5_);
      }
  }


  public EntityFlechette(World worldIn, EntityLivingBase shooter, float p_i1756_3_)
  {
      super(worldIn);
      this.renderDistanceWeight = 10.0D;
      this.shootingEntity = shooter;

      if (shooter instanceof EntityPlayer)
      {
          this.canBePickedUp = 1;
      }

      this.setSize(0.5F, 0.5F);
      this.setLocationAndAngles(shooter.posX, shooter.posY + (double)shooter.getEyeHeight(), shooter.posZ, shooter.rotationYaw, shooter.rotationPitch);
      this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0F * (float)Math.PI) * 0.16F);
      this.posY -= 0.10000000149011612D;
      this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0F * (float)Math.PI) * 0.16F);
      this.setPosition(this.posX, this.posY, this.posZ);
      this.motionX = (double)(-MathHelper.sin(this.rotationYaw / 180.0F * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0F * (float)Math.PI));
      this.motionZ = (double)(MathHelper.cos(this.rotationYaw / 180.0F * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0F * (float)Math.PI));
      this.motionY = (double)(-MathHelper.sin(this.rotationPitch / 180.0F * (float)Math.PI));
      this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, p_i1756_3_ * 1.5F, 1.0F);
  }


  protected void entityInit()
  {
    this.dataWatcher.addObject(16, Byte.valueOf((byte)0));
  }

  public void setThrowableHeading(double par1, double par3, double par5, float par7, float par8)
  {
    float f2 = MathHelper.sqrt_double(par1 * par1 + par3 * par3 + par5 * par5);
    par1 /= f2;
    par3 /= f2;
    par5 /= f2;
    par1 += this.rand.nextGaussian() * (this.rand.nextBoolean() ? -1 : 1) * 0.007499999832361937D * par8;
    par3 += this.rand.nextGaussian() * (this.rand.nextBoolean() ? -1 : 1) * 0.007499999832361937D * par8;
    par5 += this.rand.nextGaussian() * (this.rand.nextBoolean() ? -1 : 1) * 0.007499999832361937D * par8;
    par1 *= par7;
    par3 *= par7;
    par5 *= par7;
    this.motionX = par1;
    this.motionY = par3;
    this.motionZ = par5;
    float f3 = MathHelper.sqrt_double(par1 * par1 + par5 * par5);
    this.prevRotationYaw = (this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0D / 3.141592653589793D));
    this.prevRotationPitch = (this.rotationPitch = (float)(Math.atan2(par3, f3) * 180.0D / 3.141592653589793D));
    this.ticksInGround = 0;
  }

  @SideOnly(Side.CLIENT)
  public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9)
  {
    setPosition(par1, par3, par5);
    setRotation(par7, par8);
  }

  @SideOnly(Side.CLIENT)
  public void setVelocity(double par1, double par3, double par5)
  {
    this.motionX = par1;
    this.motionY = par3;
    this.motionZ = par5;

    if ((this.prevRotationPitch == 0.0F) && (this.prevRotationYaw == 0.0F))
    {
      float f = MathHelper.sqrt_double(par1 * par1 + par5 * par5);
      this.prevRotationYaw = (this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0D / 3.141592653589793D));
      this.prevRotationPitch = (this.rotationPitch = (float)(Math.atan2(par3, f) * 180.0D / 3.141592653589793D));
      this.prevRotationPitch = this.rotationPitch;
      this.prevRotationYaw = this.rotationYaw;
      setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
      this.ticksInGround = 0;
    }
  }

  public void onUpdate()
  {
      super.onUpdate();

      if (this.prevRotationPitch == 0.0F && this.prevRotationYaw == 0.0F)
      {
          float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
          this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0D / Math.PI);
          this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, (double)f) * 180.0D / Math.PI);
      }

      BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
      IBlockState iblockstate = this.worldObj.getBlockState(blockpos);
      Block block = iblockstate.getBlock();

      if (block.getMaterial() != Material.air)
      {
          block.setBlockBoundsBasedOnState(this.worldObj, blockpos);
          AxisAlignedBB axisalignedbb = block.getCollisionBoundingBox(this.worldObj, blockpos, iblockstate);

          if (axisalignedbb != null && axisalignedbb.isVecInside(new Vec3(this.posX, this.posY, this.posZ)))
          {
              this.inGround = true;
          }
      }

      if (this.arrowShake > 0)
      {
          --this.arrowShake;
      }

      if (this.inGround)
      {
          int j = block.getMetaFromState(iblockstate);

          if (block == this.inTile && j == this.inData)
          {
              ++this.ticksInGround;

              if (this.ticksInGround >= 1200)
              {
                  this.setDead();
              }
          }
          else
          {
              this.inGround = false;
              this.motionX *= (double)(this.rand.nextFloat() * 0.2F);
              this.motionY *= (double)(this.rand.nextFloat() * 0.2F);
              this.motionZ *= (double)(this.rand.nextFloat() * 0.2F);
              this.ticksInGround = 0;
              this.ticksInAir = 0;
          }
      }
      else
      {
          ++this.ticksInAir;
          Vec3 vec31 = new Vec3(this.posX, this.posY, this.posZ);
          Vec3 vec3 = new Vec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
          MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec31, vec3, false, true, false);
          vec31 = new Vec3(this.posX, this.posY, this.posZ);
          vec3 = new Vec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);

          if (movingobjectposition != null)
          {
              vec3 = new Vec3(movingobjectposition.hitVec.xCoord, movingobjectposition.hitVec.yCoord, movingobjectposition.hitVec.zCoord);
          }

          Entity entity = null;
          List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.getEntityBoundingBox().addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0D, 1.0D, 1.0D));
          double d0 = 0.0D;
          int i;
          float f1;

          for (i = 0; i < list.size(); ++i)
          {
              Entity entity1 = (Entity)list.get(i);

              if (entity1.canBeCollidedWith() && (entity1 != this.shootingEntity || this.ticksInAir >= 5))
              {
                  f1 = 0.3F;
                  AxisAlignedBB axisalignedbb1 = entity1.getEntityBoundingBox().expand((double)f1, (double)f1, (double)f1);
                  MovingObjectPosition movingobjectposition1 = axisalignedbb1.calculateIntercept(vec31, vec3);

                  if (movingobjectposition1 != null)
                  {
                      double d1 = vec31.distanceTo(movingobjectposition1.hitVec);

                      if (d1 < d0 || d0 == 0.0D)
                      {
                          entity = entity1;
                          d0 = d1;
                      }
                  }
              }
          }

          if (entity != null)
          {
              movingobjectposition = new MovingObjectPosition(entity);
          }

          if (movingobjectposition != null && movingobjectposition.entityHit != null && movingobjectposition.entityHit instanceof EntityPlayer)
          {
              EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.entityHit;

              if (entityplayer.capabilities.disableDamage || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).canAttackPlayer(entityplayer))
              {
                  movingobjectposition = null;
              }
          }


      }
  }

  public void writeEntityToNBT(NBTTagCompound tagCompound)
  {
      tagCompound.setShort("xTile", (short)this.xTile);
      tagCompound.setShort("yTile", (short)this.yTile);
      tagCompound.setShort("zTile", (short)this.zTile);
      tagCompound.setShort("life", (short)this.ticksInGround);
      ResourceLocation resourcelocation = (ResourceLocation)Block.blockRegistry.getNameForObject(this.inTile);
      tagCompound.setString("inTile", resourcelocation == null ? "" : resourcelocation.toString());
      tagCompound.setByte("inData", (byte)this.inData);
      tagCompound.setByte("shake", (byte)this.arrowShake);
      tagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
      tagCompound.setByte("pickup", (byte)this.canBePickedUp);
      tagCompound.setDouble("damage", this.damage);
  }

  public void readEntityFromNBT(NBTTagCompound tagCompund)
  {
      this.xTile = tagCompund.getShort("xTile");
      this.yTile = tagCompund.getShort("yTile");
      this.zTile = tagCompund.getShort("zTile");
      this.ticksInGround = tagCompund.getShort("life");

      if (tagCompund.hasKey("inTile", 8))
      {
          this.inTile = Block.getBlockFromName(tagCompund.getString("inTile"));
      }
      else
      {
          this.inTile = Block.getBlockById(tagCompund.getByte("inTile") & 255);
      }

      this.inData = tagCompund.getByte("inData") & 255;
      this.arrowShake = tagCompund.getByte("shake") & 255;
      this.inGround = tagCompund.getByte("inGround") == 1;

      if (tagCompund.hasKey("damage", 99))
      {
          this.damage = tagCompund.getDouble("damage");
      }

      if (tagCompund.hasKey("pickup", 99))
      {
          this.canBePickedUp = tagCompund.getByte("pickup");
      }
      else if (tagCompund.hasKey("player", 99))
      {
          this.canBePickedUp = tagCompund.getBoolean("player") ? 1 : 0;
      }
  }

  public void onCollideWithPlayer(EntityPlayer entityIn)
  {
      if (!this.worldObj.isRemote && this.inGround && this.arrowShake <= 0)
      {
          boolean flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && entityIn.capabilities.isCreativeMode;

          if (this.canBePickedUp == 1 && !entityIn.inventory.addItemStackToInventory(new ItemStack(Items.arrow, 1)))
          {
              flag = false;
          }

          if (flag)
          {
              this.playSound("random.pop", 0.2F, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7F + 1.0F) * 2.0F);
              entityIn.onItemPickup(this, 1);
              this.setDead();
          }
      }
  }

  protected boolean canTriggerWalking()
  {
    return false;
  }

  @SideOnly(Side.CLIENT)
  public float getShadowSize()
  {
    return 0.0F;
  }

  public void setDamage(double par1)
  {
    this.damage = par1;
  }

  public double getDamage()
  {
    return this.damage;
  }

  public void setIsCritical(boolean par1)
  {
    byte b0 = this.dataWatcher.getWatchableObjectByte(16);

    if (par1)
    {
      this.dataWatcher.updateObject(16, Byte.valueOf((byte)(b0 | 0x1)));
    }
    else
    {
      this.dataWatcher.updateObject(16, Byte.valueOf((byte)(b0 & 0xFFFFFFFE)));
    }
  }

  public boolean getIsCritical()
  {
    byte b0 = this.dataWatcher.getWatchableObjectByte(16);
    return (b0 & 0x1) != 0;
  }
}