package mod.common.entity;

import java.util.List;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityCoelophysis extends EntityMob
{
  public EntityCoelophysis(World world)
  {
    super(world);
  }

  public void applyEntityAttributes()
  {
    super.applyEntityAttributes();
    getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(40.0D);
    getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(12.0D);
    getEntityAttribute(SharedMonsterAttributes.knockbackResistance).setBaseValue(0D);
    getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(30.0D);
    setSize(2.0F, 2.0F);
  }
  
  public void updateAITasks()
  {

  List list = worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.fromBounds(posX, posY, posZ, posX + 1, posY + 1, posZ + 1).expand(16D, 4D, 16D));

  for(int i = 0; i<list.size(); i++)
  {
	  Entity entity = (Entity)list.get(i);
	  if(!list.isEmpty())
	  {
		  this.attackEntityAsMob(entity);
	  }
  }

  super.updateEntityActionState();
  }

}