package mod.common.block.gui;

import mod.common.block.container.ContainerAnalyzer;
import mod.common.block.container.ContainerCombiner;
import mod.common.block.container.ContainerCouveuse;
import mod.common.block.container.ContainerExtractor;
import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.block.entity.TileEntityCombiner;
import mod.common.block.entity.TileEntityCouveuse;
import mod.common.block.entity.TileEntityExtractor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;



public class GuiHandler implements IGuiHandler
{
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		switch (ID) {
		
		case 0:
		TileEntity tile = world.getTileEntity(x ,y ,z);
		if(tile instanceof TileEntityAnalyzer)
		{
			return new ContainerAnalyzer((TileEntityAnalyzer)tile, player.inventory);
		}
		
		case 1:
			TileEntity tile1 = world.getTileEntity(x ,y ,z);
			if(tile1 instanceof TileEntityCouveuse)
			{
				return new ContainerCouveuse((TileEntityCouveuse)tile1, player.inventory);
			}
			
		case 2:
			TileEntity tile2 = world.getTileEntity(x ,y ,z);
			if(tile2 instanceof TileEntityExtractor)
			{
				return new ContainerExtractor((TileEntityExtractor)tile2, player.inventory);
			}
		case 3:
			TileEntity tile3 = world.getTileEntity(x ,y ,z);
			if(tile3 instanceof TileEntityCombiner)
			{
				return new ContainerCombiner((TileEntityCombiner)tile3, player.inventory);
			}
	}
		
		return null;
	}
	
	
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		switch (ID) {
		
		case 0:
		TileEntity tile = world.getTileEntity(x ,y ,z);
		if(tile instanceof TileEntityAnalyzer)
		{
			return new GuiAnalyzer((TileEntityAnalyzer)tile, player.inventory);
		}
		
		case 1:
			TileEntity tile1 = world.getTileEntity(x ,y ,z);
			if(tile1 instanceof TileEntityCouveuse)
			{
				return new GuiCouveuse((TileEntityCouveuse)tile1, player.inventory);
			}
			
		case 2:
			TileEntity tile2 = world.getTileEntity(x ,y ,z);
			if(tile2 instanceof TileEntityExtractor)
			{
				return new GuiExtractor((TileEntityExtractor)tile2, player.inventory);
			}
		case 3:
			TileEntity tile3 = world.getTileEntity(x ,y ,z);
			if(tile3 instanceof TileEntityCombiner)
			{
				return new GuiCombiner((TileEntityCombiner)tile3, player.inventory);
			}
	}
		
		return null;
	}





}