package mod.common.block.gui;

import mod.DinoCraft;
import mod.common.block.container.ContainerCouveuse;
import mod.common.block.container.ContainerExtractor;
import mod.common.block.entity.TileEntityCouveuse;
import mod.common.block.entity.TileEntityExtractor;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

public class GuiExtractor extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation(DinoCraft.MODID,"textures/gui/container/guiExtractor.png");
    @SuppressWarnings("unused")
	private TileEntityExtractor tileBlockExtractor;
    private IInventory playerInv;
	
	public GuiExtractor(TileEntityExtractor tile, InventoryPlayer inventory) 
	{
		super(new ContainerExtractor(tile, inventory));
        this.tileBlockExtractor = tile;
        this.playerInv = inventory;
        this.allowUserInput = false;
        this.ySize = 207;
        this.xSize = 195;
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float partialRenderTick, int x, int y) 
	{
		
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 46, this.xSize, this.ySize);
        
		
        if(this.tileBlockExtractor.isBurning())
        {
        	int i = this.tileBlockExtractor.getCookProgress();
        	this.drawTexturedModalRect(k + 72, l + 48, 0, 1, 76, i);
        	
        }
	}
	
	protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        this.fontRendererObj.drawString(this.playerInv.hasCustomName() ? this.playerInv.getName() : I18n.format(this.playerInv.getName()), 10, this.ySize - 98, 4210752);
    }
}
