package mod.common.block.gui;

import mod.DinoCraft;
import mod.common.block.container.ContainerCombiner;
import mod.common.block.entity.TileEntityCombiner;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

public class GuiCombiner extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation(DinoCraft.MODID,"textures/gui/container/guiCombiner.png");
    @SuppressWarnings("unused")
	private TileEntityCombiner tileBlockCombiner;
    private IInventory playerInv;
	
	public GuiCombiner(TileEntityCombiner tile, InventoryPlayer inventory) 
	{
		super(new ContainerCombiner(tile, inventory));
        this.tileBlockCombiner = tile;
        this.playerInv = inventory;
        this.allowUserInput = false;
        this.ySize = 207;
        this.xSize = 195;
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float partialRenderTick, int x, int y) 
	{
		
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l , 0, 46, this.xSize, this.ySize);
        
		
        if(this.tileBlockCombiner.isBurning())
        {
        	int i = this.tileBlockCombiner.getCookProgress();
        	this.drawTexturedModalRect(k + 48, l + 37, 0, 1, 99, i);
        	
        }
	}
	
	protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        this.fontRendererObj.drawString(this.playerInv.hasCustomName() ? this.playerInv.getName() : I18n.format(this.playerInv.getName()), 10, this.ySize - 98, 4210752);
    }

}
