package mod.common.block.gui;

import org.lwjgl.opengl.GL11;




import mod.DinoCraft;
import mod.common.block.container.ContainerAnalyzer;
import mod.common.block.entity.TileEntityAnalyzer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.client.resources.I18n;

public class GuiAnalyzer extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation(DinoCraft.MODID,"textures/gui/container/guiAnalyzer.png");
    @SuppressWarnings("unused")
	private TileEntityAnalyzer tileBlockAnalyzer;
    private IInventory playerInv;
	
	public GuiAnalyzer(TileEntityAnalyzer tile, InventoryPlayer inventory) 
	{
		super(new ContainerAnalyzer(tile, inventory));
        this.tileBlockAnalyzer = tile;
        this.playerInv = inventory;
        this.allowUserInput = false;
        this.ySize = 207;
        this.xSize = 195;
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float partialRenderTick, int x, int y) 
	{
		
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 46, this.xSize, this.ySize);
        
		
        if(this.tileBlockAnalyzer.isBurning())
        {
        	int i = this.tileBlockAnalyzer.getCookProgress();
        	this.drawTexturedModalRect(k + 67, l + 47, 0, 1, 76, i);
        	
        }
	}
	
	protected void drawGuiContainerForegroundLayer(int x, int y)
    {
        this.fontRendererObj.drawString(this.playerInv.hasCustomName() ? this.playerInv.getName() : I18n.format(this.playerInv.getName()), 10, this.ySize - 98, 4210752);
    }

}
