package mod.common.block.entity;

import mod.DinoCraft;
import mod.client.model.ModelBarriereHaut;
import mod.client.model.ModelEgg;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

public class TileEntityEggSpecialRenderer extends TileEntitySpecialRenderer 
{
	
public static ModelEgg model = new ModelEgg();
public static ResourceLocation texture = new ResourceLocation(DinoCraft.MODID, "textures/blocks/blockEgg.png");

public TileEntityEggSpecialRenderer() 
{
    this.setRendererDispatcher(TileEntityRendererDispatcher.instance);
}

@Override
public void renderTileEntityAt(TileEntity tile, double posX, double posZ, double posY, float partialRenderTick, int p_180535_9_) {
    
	this.renderTileEntityEggAt((TileEntityEgg)tile, posX, posZ, posY , partialRenderTick);

	
}

private void renderTileEntityEggAt(TileEntityEgg tile, double x, double y, double z, float partialRenderTick) 
{
  GL11.glPushMatrix(); 
  GL11.glTranslated(x + 0.5D, y + 1.5D, z + 0.5D); 
  GL11.glRotatef(180F, 0.0F, 0.0F, 1.0F); 
  GL11.glRotatef(90.0F * tile.getDirection(), 0.0F, 1.0F, 0.0F);
  this.bindTexture(texture); 
  model.renderAll(); 
  GL11.glPopMatrix(); 
}



}
