package mod.common.block.container;

import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.block.entity.TileEntityCouveuse;
import mod.common.recipes.SlotResult;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerCouveuse extends Container
{

    private TileEntityCouveuse tileBlockCouveuse;

    public ContainerCouveuse(TileEntityCouveuse tile, InventoryPlayer inventory) 
    {
        this.tileBlockCouveuse = tile;
        this.addSlotToContainer(new Slot(tile, 0, 89, 31));
        this.addSlotToContainer(new SlotResult(tile, 1, 89, 87));
        this.bindPlayerInventory(inventory);
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return this.tileBlockCouveuse.isUseableByPlayer(player);
    }

    private void bindPlayerInventory(InventoryPlayer inventory) 
    {
        int i;
        
        for (i = 0; i < 3; ++i) 
        {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(inventory, j + i * 9 + 9, 17 + j * 18, 125 + i * 18));
            }
        }

        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot(inventory, i, 17 + i * 18, 183));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) 
    {
    	
        ItemStack itemstack = null;
        
        Slot slot = (Slot) this.inventorySlots.get(index);

        if (slot != null && slot.getHasStack()) 
        {
            ItemStack itemstack1 = slot.getStack();
            
            itemstack = itemstack1.copy();

            if (index < this.tileBlockCouveuse.getSizeInventory()) 
            {
                if (!this.mergeItemStack(itemstack1, this.tileBlockCouveuse.getSizeInventory(), this.inventorySlots.size(), true)) 
                { 
                	return null; 
                }
            } 
            else if (!this.mergeItemStack(itemstack1, 0, this.tileBlockCouveuse.getSizeInventory(), false)) 
            { 
            	return null; 
            }

            if (itemstack1.stackSize == 0)
            {
                slot.putStack((ItemStack) null);
            } 
            else 
            {
                slot.onSlotChanged();
            }
        }

        return itemstack;
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        this.tileBlockCouveuse.closeInventory(player);
    }
}
