package mod.common.block.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import mod.common.block.entity.TileEntityCombiner;
import mod.common.recipes.SlotResult;


public class ContainerCombiner extends Container
{

    private TileEntityCombiner tileBlockCombiner;

    public ContainerCombiner(TileEntityCombiner tile, InventoryPlayer inventory) 
    {
        this.tileBlockCombiner = tile;
        this.addSlotToContainer(new Slot(tile, 0, 49, 19));
        this.addSlotToContainer(new Slot(tile, 1, 130, 19));
        this.addSlotToContainer(new Slot(tile, 2, 89, 49));
        this.addSlotToContainer(new SlotResult(tile, 3, 89, 83));
        this.bindPlayerInventory(inventory);
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return this.tileBlockCombiner.isUseableByPlayer(player);
    }

    private void bindPlayerInventory(InventoryPlayer inventory) 
    {
        int i;
        
        for (i = 0; i < 3; ++i) 
        {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(inventory, j + i * 9 + 9, 17 + j * 18, 125 + i * 18));
            }
        }

        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot(inventory, i, 17 + i * 18, 183));
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) 
    {
    	
        ItemStack itemstack = null;
        
        Slot slot = (Slot) this.inventorySlots.get(index);

        if (slot != null && slot.getHasStack()) 
        {
            ItemStack itemstack1 = slot.getStack();
            
            itemstack = itemstack1.copy();

            if (index < this.tileBlockCombiner.getSizeInventory()) 
            {
                if (!this.mergeItemStack(itemstack1, this.tileBlockCombiner.getSizeInventory(), this.inventorySlots.size(), true)) 
                { 
                	return null; 
                }
            } 
            else if (!this.mergeItemStack(itemstack1, 0, this.tileBlockCombiner.getSizeInventory(), false)) 
            { 
            	return null; 
            }

            if (itemstack1.stackSize == 0)
            {
                slot.putStack((ItemStack) null);
            } 
            else 
            {
                slot.onSlotChanged();
            }
        }

        return itemstack;
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        this.tileBlockCombiner.closeInventory(player);
    }
}
