package mod.common.block;


import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ItemBlockEgg extends ItemBlock 
{
	public ItemBlockEgg(Block block)
	{
		super(block);
		this.setMaxDamage(0);
		this.setHasSubtypes(true);
	}
	
	public int getMetadata(int metadata)
	{
		return metadata;
	}


	public String getUnlocalizedName(ItemStack stack)
	{
		int metadata = stack.getItemDamage();
		if(metadata < 0 || metadata >= BlockEgg.subBlock.length)
		{
			metadata = 0;
		}
		return super.getUnlocalizedName() + "." + BlockEgg.subBlock[metadata];
	}
}
