package mod.common.block;

import mod.DinoCraft;
import mod.common.block.entity.TileEntityAnalyzer;
import mod.common.block.entity.TileEntityBarriere;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockRegister 
{

    public static Block BlockBarriere;
    public static Block BlockTronc;
    public static Block BlockFeuille;
    public static Block BlockPousse;
    public static Block BlockAnalyzer;
    public static Block BlockAmbre;
    public static Block BlockEgg;
    public static Block BlockEggIndominus;
    public static Block BlockFossiliser;
    public static Block BlockCouveuse;
    public static Block BlockExtractor;
    public static Block BlockCombiner;
	public static Block BlockPortail;

        public static void register()
    {
    	BlockBarriere = new BlockBarriere(Material.rock).setCreativeTab(CreativeTabs.tabBlock);
        BlockTronc = new BlockTronc().setCreativeTab(CreativeTabs.tabBlock).setHardness(2.0F);
        BlockFeuille = new BlockFeuille(Material.leaves).setCreativeTab(CreativeTabs.tabBlock).setHardness(0.1F);
        BlockPousse = new BlockPousse().setHardness(0.5F);
        BlockAnalyzer = new BlockAnalyzer().setCreativeTab(CreativeTabs.tabBlock);
        BlockAmbre = new BlockAmbre(Material.rock).setCreativeTab(CreativeTabs.tabBlock);
        BlockEgg = new BlockEgg();
        BlockEggIndominus = new BlockEggIndominus(Material.dragonEgg);
        BlockFossiliser = new BlockFossiliser(Material.rock);
    	BlockCouveuse = new BlockBroody(Material.rock).setCreativeTab(CreativeTabs.tabBlock).setLightLevel(1.0F);
    	BlockExtractor = new BlockExtractor(Material.rock).setCreativeTab(CreativeTabs.tabBlock);
    	BlockCombiner = new BlockCombiner(Material.rock).setCreativeTab(CreativeTabs.tabBlock);
    	BlockPortail = new BlockPortail(Material.portal);
    	
        GameRegistry.registerBlock(BlockAnalyzer,"block_analyzer");
        GameRegistry.registerBlock(BlockBarriere, "block_barriere");
        GameRegistry.registerBlock(BlockTronc, "block_tronc");
        GameRegistry.registerBlock(BlockFeuille, "block_feuille");
        GameRegistry.registerBlock(BlockPousse, "block_pousse");
        GameRegistry.registerBlock(BlockAmbre, "block_ambre");
        GameRegistry.registerBlock(BlockEgg, ItemBlockEgg.class, "block_egg");
        GameRegistry.registerBlock(BlockEggIndominus, "block_eggindominus");
        GameRegistry.registerBlock(BlockFossiliser, "block_fossiliser");
        GameRegistry.registerBlock(BlockCouveuse, "block_couveuse");
        GameRegistry.registerBlock(BlockExtractor, "block_extractor");
        GameRegistry.registerBlock(BlockCombiner, "block_combiner");
        GameRegistry.registerBlock(BlockPortail, "block_portail");

    }
}
