package mod.common.block;

import java.util.Random;

import mod.client.ClientProxy;
import mod.common.block.entity.TileEntityEgg;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;


public class BlockEggIndominus extends Block

{

	public void onBlockPlaced(EntityLivingBase living, World world, BlockPos pos)
	{
	    int direction = MathHelper.floor_double(living.rotationYaw * 4.0F / 360.0F + 2.5D) & 0x3;
	    TileEntity te = world.getTileEntity(pos);
	    if ((te instanceof TileEntityEgg))
	    {
	      ((TileEntityEgg)te).setDirection((byte)direction);
	      world.markBlockForUpdate(pos);
	    }
	}


   

	
	protected BlockEggIndominus(Material material) {
		super(material);
		this.setBlockBounds(0.0625F, 0.0F, 0.0625F, 0.8000F, 1.0F, 0.8000F);
	}

    
 

	/*@Override
	    public TileEntity createTileEntity(World world, int metadata)
	    {
	        if(metadata == 0)
	        {
	        return new TileEntityEgg();
	        }
	        else if(metadata == 1)
	        {
	            return new TileEntityEgg();
	        }
	        else if(metadata == 2)
	        {
	            return new TileEntityEgg();
	        }
	        return null;
	    }
	 
	 

	    @Override
	    public boolean hasTileEntity(int metadata)
	    {
	        if(metadata >= 0 && metadata <= 2)
	            return true;
	        return false;
	    }
	    public boolean isOpaqueCube()
	    {
	        return false;
	    }

	    public boolean renderAsNormalBlock()
	    {
	        return false;
	    }

	    public int getRenderType()
	    {
	        return ClientProxy.tesrRenderId;  
	    }*/
}

		
