package mod.common.block;

import mod.DinoCraft;
import mod.client.ClientProxy;
import mod.common.block.entity.TileEntityBarriere;
import mod.common.block.entity.TileEntityCouveuse;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockBroody extends Block

{

	public void onBlockPlacedBy(World world, BlockPos pos, EntityLivingBase living, ItemStack stack) {
	    int direction = MathHelper.floor_double(living.rotationYaw * 4.0F / 360.0F + 2.5D) & 0x3;
	    TileEntity te = world.getTileEntity(pos);
	    if ((te instanceof TileEntityCouveuse))
	    {
	      ((TileEntityCouveuse)te).setDirection((byte)direction);
	      world.markBlockForUpdate(pos);
	    }
	  }


	
	
	protected BlockBroody(Material material) {
		super(material);
		
	}



	/*@Override
	    public TileEntity createTileEntity(World world, int metadata)
	    {
	        if(metadata == 0)
	        {
	        return new TileEntityCouveuse();
	        }
	        else if(metadata == 1)
	        {
	            return new TileEntityCouveuse();
	        }
	        else if(metadata == 2)
	        {
	            return new TileEntityCouveuse();
	        }
	        return null;
	    }
	 
	 

	    @Override
	    public boolean hasTileEntity(int metadata)
	    {
	        if(metadata >= 0 && metadata <= 2)
	            return true;
	        return false;
	    }*/
	    
	    public void breakBlock(World world, BlockPos pos, IBlockState state, Block block, int metadata)
	    {
	        TileEntity tileentity = world.getTileEntity(pos);

			        if (tileentity instanceof IInventory)
			        {
			        	IInventory inv = (IInventory)tileentity;
			            for (int i1 = 0; i1 < inv.getSizeInventory(); ++i1)
			            {
			                ItemStack itemstack = inv.getStackInSlot(i1);
			
			                if (itemstack != null)
			                {
			                    float f = world.rand.nextFloat() * 0.8F + 0.1F;
			                    float f1 = world.rand.nextFloat() * 0.8F + 0.1F;
			                    EntityItem entityitem;
			
			                    for (float f2 = world.rand.nextFloat() * 0.8F + 0.1F; itemstack.stackSize > 0; world.spawnEntityInWorld(entityitem))
			                    {
			                        int j1 = world.rand.nextInt(21) + 10;
			
			                        if (j1 > itemstack.stackSize)
			                        {
			                            j1 = itemstack.stackSize;
			                        }
			
			                        itemstack.stackSize -= j1;
			                        entityitem = new EntityItem(world , maxX, maxY, maxZ, new ItemStack(itemstack.getItem(), j1, itemstack.getItemDamage()));
			                        float f3 = 0.05F;
			                        entityitem.motionX = (double)((float)world.rand.nextGaussian() * f3);
			                        entityitem.motionY = (double)((float)world.rand.nextGaussian() * f3 + 0.2F);
			                        entityitem.motionZ = (double)((float)world.rand.nextGaussian() * f3);
			
			                        if (itemstack.hasTagCompound())
			                        {
			                            entityitem.getEntityItem().setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
			                        }
			                    }
			                }
			            }
			
		            world.func_175662_w(pos);
		        }

	        super.breakBlock(world, pos, state);;
	    }
	    
	    
	    
	    public boolean isOpaqueCube()
	    {
	        return false;
	    }

	    public boolean renderAsNormalBlock()
	    {
	        return false;
	    }

	    public int getRenderType()
	    {
	        return ClientProxy.tesrRenderId;  }

		
	    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitx, float hity, float hitz)
	    {
	        if (world.isRemote)
	        {
	            return true;
	        }
	        else
	        {
	        	player.openGui(DinoCraft.instance, 0, world, x, y, z);
	            return true;
	        }
	    }
		
	   

}

