package mod.common.block;

import java.util.List;

import org.lwjgl.opengl.GL11;



import mod.DinoCraft;
import mod.client.ClientProxy;
import mod.common.block.entity.TileEntityBarriere;
import mod.common.block.entity.TileEntityBarriereSpecialRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBarriere extends Block

{

	public void onBlockPlacedBy(World world, BlockPos pos, EntityLivingBase living, ItemStack stack) {
	    int direction = MathHelper.floor_double(living.rotationYaw * 4.0F / 360.0F + 2.5D) & 0x3;
	    TileEntity te = world.getTileEntity(pos);
	    if ((te instanceof TileEntityBarriere))
	    {
	      ((TileEntityBarriere)te).setDirection((byte)direction);
	      world.markBlockForUpdate(pos);
	    }
	  }


	  public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity)
	  {
	    entity.attackEntityFrom(DamageSource.cactus, 0.0F);
	  }
	
	
	
	protected BlockBarriere(Material material) {
		super(material);
		
	}



	public TileEntity createTileEntity(int metadata)
	    {
	        if(metadata == 0)
	        {
	        return new TileEntityBarriere();
	        }
	        else if(metadata == 1)
	        {
	            return new TileEntityBarriere();
	        }
	        else if(metadata == 2)
	        {
	            return new TileEntityBarriere();
	        }
	        return null;
	    }
	 
	 

	    public boolean hasTileEntity(int metadata)
	    {
	        if(metadata >= 0 && metadata <= 2)
	            return true;
	        return false;
	    }
	    
	    public boolean isOpaqueCube()
	    {
	        return false;
	    }

	    public boolean renderAsNormalBlock()
	    {
	        return false;
	    }

	    public int getRenderType()
	    {
	        return ClientProxy.tesrRenderId;  }

		

		

}
