package mod.client.render;


import mod.common.entity.EntityFlechette;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.fml.relauncher.Side;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderFlechette extends RenderLiving
{
  public RenderFlechette(ModelBase par1ModelBase, float par2, RenderManager renderManager)
  {
    super(renderManager, par1ModelBase, par2);
  }

  protected ResourceLocation getEntityTexture(Entity var1)
  {
    return new ResourceLocation("dinocraft", "textures/entity/EntityFlechette.png");
  }

  public void doRender(EntityFlechette par1EntityFlechette, double par2, double par4, double par6, float par8, float par9)
  {
    bindEntityTexture(par1EntityFlechette);
    GL11.glPushMatrix();
    GL11.glTranslatef((float)par2, (float)par4, (float)par6);
    GL11.glRotatef(par1EntityFlechette.prevRotationYaw + (par1EntityFlechette.rotationYaw - par1EntityFlechette.prevRotationYaw) * par9 - 90.0F, 0.0F, 1.0F, 0.0F);
    GL11.glRotatef(par1EntityFlechette.prevRotationPitch + (par1EntityFlechette.rotationPitch - par1EntityFlechette.prevRotationPitch) * par9, 0.0F, 0.0F, 1.0F);
    Tessellator tessellator = Tessellator.getInstance();
    WorldRenderer worldrenderer = tessellator.getWorldRenderer();
    byte b0 = 0;
    float f2 = 0.0F;
    float f3 = 0.5F;
    float f4 = (0 + b0 * 10) / 32.0F;
    float f5 = (5 + b0 * 10) / 32.0F;
    float f6 = 0.0F;
    float f7 = 0.15625F;
    float f8 = (5 + b0 * 10) / 32.0F;
    float f9 = (10 + b0 * 10) / 32.0F;
    float f10 = 0.05625F;
    GL11.glEnable(32826);

    GL11.glRotatef(45.0F, 1.0F, 0.0F, 0.0F);
    GL11.glScalef(f10, f10, f10);
    GL11.glTranslatef(-4.0F, 0.0F, 0.0F);
    GL11.glNormal3f(f10, 0.0F, 0.0F);
    worldrenderer.startDrawingQuads();
    worldrenderer.addVertexWithUV(-7.0D, -2.0D, -2.0D, f6, f8);
    worldrenderer.addVertexWithUV(-7.0D, -2.0D, 2.0D, f7, f8);
    worldrenderer.addVertexWithUV(-7.0D, 2.0D, 2.0D, f7, f9);
    worldrenderer.addVertexWithUV(-7.0D, 2.0D, -2.0D, f6, f9);
    tessellator.draw();
    GL11.glNormal3f(-f10, 0.0F, 0.0F);
    worldrenderer.startDrawingQuads();
    worldrenderer.addVertexWithUV(-7.0D, 2.0D, -2.0D, f6, f8);
    worldrenderer.addVertexWithUV(-7.0D, 2.0D, 2.0D, f7, f8);
    worldrenderer.addVertexWithUV(-7.0D, -2.0D, 2.0D, f7, f9);
    worldrenderer.addVertexWithUV(-7.0D, -2.0D, -2.0D, f6, f9);
    tessellator.draw();

    for (int i = 0; i < 4; i++)
    {
      GL11.glRotatef(90.0F, 1.0F, 0.0F, 0.0F);
      GL11.glNormal3f(0.0F, 0.0F, f10);
      worldrenderer.startDrawingQuads();
      worldrenderer.addVertexWithUV(-8.0D, -2.0D, 0.0D, f2, f4);
      worldrenderer.addVertexWithUV(8.0D, -2.0D, 0.0D, f3, f4);
      worldrenderer.addVertexWithUV(8.0D, 2.0D, 0.0D, f3, f5);
      worldrenderer.addVertexWithUV(-8.0D, 2.0D, 0.0D, f2, f5);
      tessellator.draw();
    }

    GL11.glDisable(32826);
    GL11.glPopMatrix();
  }

  public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9)
  {
    doRender((EntityFlechette)par1Entity, par2, par4, par6, par8, par9);
  }
}