package mod.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;

public class ModelFrog extends ModelBase
{
  ModelRenderer chest;
  ModelRenderer head;
  ModelRenderer legg;
  ModelRenderer legd;
  ModelRenderer feetg;
  ModelRenderer feetd;
  ModelRenderer leg2d;
  ModelRenderer leg2g;
  ModelRenderer feet2g;
  ModelRenderer feet2d;

  public ModelFrog()
  {
    this.textureWidth = 64;
    this.textureHeight = 32;

    this.chest = new ModelRenderer(this, 0, 0);
    this.chest.addBox(-2.0F, -2.0F, -2.0F, 4, 2, 4);
    this.chest.setRotationPoint(-1.0F, 19.5F, 0.0F);
    this.chest.setTextureSize(64, 32);
    this.chest.mirror = true;
    setRotation(this.chest, 0.0F, 0.0F, -0.26025F);
    this.head = new ModelRenderer(this, 16, 0);
    this.head.addBox(0.0F, 0.0F, 0.0F, 3, 3, 4);
    this.head.setRotationPoint(0.3F, 16.6F, -2.0F);
    this.head.setTextureSize(64, 32);
    this.head.mirror = true;
    setRotation(this.head, 0.0F, 0.0F, 0.0F);
    this.legg = new ModelRenderer(this, 0, 6);
    this.legg.addBox(0.0F, 0.0F, 0.0F, 1, 3, 1);
    this.legg.setRotationPoint(0.5F, 19.0F, 2.0F);
    this.legg.setTextureSize(64, 32);
    this.legg.mirror = true;
    setRotation(this.legg, 0.0F, 0.0F, -0.1661677F);
    this.legd = new ModelRenderer(this, 4, 6);
    this.legd.addBox(0.0F, 0.0F, 0.0F, 1, 3, 1);
    this.legd.setRotationPoint(0.5F, 19.0F, -3.0F);
    this.legd.setTextureSize(64, 32);
    this.legd.mirror = true;
    setRotation(this.legd, 0.0F, 0.0F, -0.166173F);
    this.feetg = new ModelRenderer(this, 0, 10);
    this.feetg.addBox(0.0F, 0.0F, 0.0F, 2, 1, 1);
    this.feetg.setRotationPoint(1.0F, 21.5F, 2.0F);
    this.feetg.setTextureSize(64, 32);
    this.feetg.mirror = true;
    setRotation(this.feetg, 0.0F, 0.0F, 0.0F);
    this.feetd = new ModelRenderer(this, 0, 12);
    this.feetd.addBox(0.0F, 0.0F, 0.0F, 2, 1, 1);
    this.feetd.setRotationPoint(1.0F, 21.5F, -3.0F);
    this.feetd.setTextureSize(64, 32);
    this.feetd.mirror = true;
    setRotation(this.feetd, 0.0F, 0.0F, 0.0F);
    this.leg2d = new ModelRenderer(this, 10, 6);
    this.leg2d.addBox(0.0F, 0.0F, 0.0F, 2, 2, 1);
    this.leg2d.setRotationPoint(-3.5F, 20.0F, -3.0F);
    this.leg2d.setTextureSize(64, 32);
    this.leg2d.mirror = true;
    setRotation(this.leg2d, 0.0F, 0.0F, -0.520501F);
    this.leg2g = new ModelRenderer(this, 10, 11);
    this.leg2g.addBox(0.0F, 0.0F, 0.0F, 2, 2, 1);
    this.leg2g.setRotationPoint(-3.5F, 20.0F, 2.0F);
    this.leg2g.setTextureSize(64, 32);
    this.leg2g.mirror = true;
    setRotation(this.leg2g, 0.0F, 0.0F, -0.520501F);
    this.feet2g = new ModelRenderer(this, 10, 9);
    this.feet2g.addBox(0.0F, 0.0F, 0.0F, 2, 1, 1);
    this.feet2g.setRotationPoint(-2.5F, 21.5F, 2.0F);
    this.feet2g.setTextureSize(64, 32);
    this.feet2g.mirror = true;
    setRotation(this.feet2g, 0.0F, 0.0F, 0.0F);
    this.feet2d = new ModelRenderer(this, 10, 14);
    this.feet2d.addBox(0.0F, 0.0F, 0.0F, 2, 1, 1);
    this.feet2d.setRotationPoint(-2.5F, 21.5F, -3.0F);
    this.feet2d.setTextureSize(64, 32);
    this.feet2d.mirror = true;
    setRotation(this.feet2d, 0.0F, 0.0F, 0.0F);
  }

  public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
  {
    super.render(entity, f, f1, f2, f3, f4, f5);
    setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    this.chest.render(f5);
    this.head.render(f5);
    this.legg.render(f5);
    this.legd.render(f5);
    this.feetg.render(f5);
    this.feetd.render(f5);
    this.leg2d.render(f5);
    this.leg2g.render(f5);
    this.feet2g.render(f5);
    this.feet2d.render(f5);
  }

  private void setRotation(ModelRenderer model, float x, float y, float z)
  {
    model.rotateAngleX = x;
    model.rotateAngleY = y;
    model.rotateAngleZ = z;
  }

  public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity)
  {
    super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
  }
}