package mod.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;

	public class ModelCoelophysis extends ModelBase

	{
	  
	    ModelRenderer Abdomen;
	    ModelRenderer Tail_1;
	    ModelRenderer Tail_2;
	    ModelRenderer GenouxDroite;
	    ModelRenderer GenouxGauche;
	    ModelRenderer LegGauche;
	    ModelRenderer LegDroite;
	    ModelRenderer Cou_1;
	    ModelRenderer Cou_2;
	    ModelRenderer Tete;
	    ModelRenderer Bouche_1;
	    ModelRenderer Bouche_2;
	    ModelRenderer BrasDroite;
	    ModelRenderer Tail_3;
	    ModelRenderer BrasGauche;
	  
	  public ModelCoelophysis()
	  {
	    textureWidth = 256;
	    textureHeight = 128;
	    
	      Abdomen = new ModelRenderer(this, 0, 0);
	      Abdomen.addBox(6F, 0F, 0F, 12, 13, 18);
	      Abdomen.setRotationPoint(-11F, 1F, -9F);
	      Abdomen.setTextureSize(64, 32);
	      Abdomen.mirror = true;
	      setRotation(Abdomen, -0.0185893F, 0F, 0F);
	      Tail_1 = new ModelRenderer(this, 60, 0);
	      Tail_1.addBox(0F, 0F, 0F, 9, 8, 18);
	      Tail_1.setRotationPoint(-3.5F, 3F, 3F);
	      Tail_1.setTextureSize(64, 32);
	      Tail_1.mirror = true;
	      setRotation(Tail_1, -0.0557679F, 0F, 0F);
	      Tail_2 = new ModelRenderer(this, 114, 0);
	      Tail_2.addBox(0F, 0F, 0F, 5, 6, 15);
	      Tail_2.setRotationPoint(-1.5F, 5F, 14F);
	      Tail_2.setTextureSize(64, 32);
	      Tail_2.mirror = true;
	      setRotation(Tail_2, 0.0929465F, 0F, 0F);
	      GenouxDroite = new ModelRenderer(this, 0, 31);
	      GenouxDroite.addBox(0F, 0F, 0F, 3, 6, 6);
	      GenouxDroite.setRotationPoint(-8F, 10F, 1F);
	      GenouxDroite.setTextureSize(64, 32);
	      GenouxDroite.mirror = true;
	      setRotation(GenouxDroite, 0F, 0F, 0F);
	      GenouxGauche = new ModelRenderer(this, 18, 31);
	      GenouxGauche.addBox(0F, 0F, 0F, 3, 6, 6);
	      GenouxGauche.setRotationPoint(7F, 10F, 1F);
	      GenouxGauche.setTextureSize(64, 32);
	      GenouxGauche.mirror = true;
	      setRotation(GenouxGauche, 0F, 0F, 0F);
	      LegGauche = new ModelRenderer(this, 0, 43);
	      LegGauche.addBox(0F, 0F, 0F, 3, 10, 3);
	      LegGauche.setRotationPoint(6F, 14F, 3.666667F);
	      LegGauche.setTextureSize(64, 32);
	      LegGauche.mirror = true;
	      setRotation(LegGauche, -0.6108652F, 0F, 0F);
	      LegDroite = new ModelRenderer(this, 12, 43);
	      LegDroite.addBox(0F, 0F, 0F, 3, 10, 3);
	      LegDroite.setRotationPoint(-7F, 14F, 3.466667F);
	      LegDroite.setTextureSize(64, 32);
	      LegDroite.mirror = true;
	      setRotation(LegDroite, -0.6108652F, 0F, 0F);
	      Cou_1 = new ModelRenderer(this, 36, 31);
	      Cou_1.addBox(0F, 0F, 0F, 9, 9, 15);
	      Cou_1.setRotationPoint(-3F, -4F, -14.1F);
	      Cou_1.setTextureSize(64, 32);
	      Cou_1.mirror = true;
	      setRotation(Cou_1, -0.7435722F, 0F, 0F);
	      Cou_2 = new ModelRenderer(this, 18, 56);
	      Cou_2.addBox(0F, 0F, 0F, 6, 10, 6);
	      Cou_2.setRotationPoint(-2F, -2F, -26F);
	      Cou_2.setTextureSize(64, 32);
	      Cou_2.mirror = true;
	      setRotation(Cou_2, 1.07818F, 0F, 0F);
	      Tete = new ModelRenderer(this, 84, 26);
	      Tete.addBox(0F, 0F, 0F, 7, 7, 8);
	      Tete.setRotationPoint(-2.5F, -7.3F, -30F);
	      Tete.setTextureSize(64, 32);
	      Tete.mirror = true;
	      setRotation(Tete, 0F, 0F, 0F);
	      Bouche_1 = new ModelRenderer(this, 42, 55);
	      Bouche_1.addBox(0F, 0F, 0F, 6, 4, 8);
	      Bouche_1.setRotationPoint(-2F, -5F, -36F);
	      Bouche_1.setTextureSize(64, 32);
	      Bouche_1.mirror = true;
	      setRotation(Bouche_1, 0F, 0F, 0F);
	      Bouche_2 = new ModelRenderer(this, 84, 41);
	      Bouche_2.addBox(0F, 0F, 0F, 6, 1, 6);
	      Bouche_2.setRotationPoint(-2F, -0.1F, -36F);
	      Bouche_2.setTextureSize(64, 32);
	      Bouche_2.mirror = true;
	      setRotation(Bouche_2, 0.1858931F, 0F, 0F);
	      BrasDroite = new ModelRenderer(this, 122, 21);
	      BrasDroite.addBox(0F, 0F, 0F, 2, 6, 2);
	      BrasDroite.setRotationPoint(-2.3F, 6F, -11F);
	      BrasDroite.setTextureSize(64, 32);
	      BrasDroite.mirror = true;
	      setRotation(BrasDroite, -1.347725F, 0.4089656F, 0.4833166F);
	      Tail_3 = new ModelRenderer(this, 130, 21);
	      Tail_3.addBox(0F, 0F, 0F, 3, 3, 7);
	      Tail_3.setRotationPoint(-0.5F, 5F, 28F);
	      Tail_3.setTextureSize(64, 32);
	      Tail_3.mirror = true;
	      setRotation(Tail_3, 0.0929465F, 0F, 0F);
	      BrasGauche = new ModelRenderer(this, 122, 21);
	      BrasGauche.addBox(0F, 0F, 0F, 2, 6, 2);
	      BrasGauche.setRotationPoint(3.7F, 7F, -11F);
	      BrasGauche.setTextureSize(64, 32);
	      BrasGauche.mirror = true;
	      setRotation(BrasGauche, -1.347725F, -0.4089656F, -0.4833166F);
	  }
	  

	  public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
	  {
	    super.render(entity, f, f1, f2, f3, f4, f5);
	    setRotationAngles(f, f1, f2, f3, f4, f5, entity);
	    Abdomen.render(f5);
	    Tail_1.render(f5);
	    Tail_2.render(f5);
	    GenouxDroite.render(f5);
	    GenouxGauche.render(f5);
	    LegGauche.render(f5);
	    LegDroite.render(f5);
	    Cou_1.render(f5);
	    Cou_2.render(f5);
	    Tete.render(f5);
	    Bouche_1.render(f5);
	    Bouche_2.render(f5);
	    BrasGauche.render(f5);
	    BrasDroite.render(f5);
	    Tail_3.render(f5);
	  }
	  
	  private void setRotation(ModelRenderer model, float x, float y, float z)
	  {
	    model.rotateAngleX = x;
	    model.rotateAngleY = y;
	    model.rotateAngleZ = z;
	  }
	  
	  public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity)
	  {
	    super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
	    
	    this.LegGauche.rotateAngleX = (MathHelper.cos(f * 0.6333056F + 1.0F) * 1.0F * f1);
	    this.LegDroite.rotateAngleX = (MathHelper.cos(f * 0.6333056F + 3.141593F) * 1.0F * f1);
	  }

	}

