package mod.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;

public class ModelBrachiosaurus extends ModelBase
{
  ModelRenderer LegFL;
  ModelRenderer LegFR;
  ModelRenderer LegBR;
  ModelRenderer LegBL;
  ModelRenderer RotuleFL;
  ModelRenderer RotuleFR;
  ModelRenderer RotuleBR;
  ModelRenderer RotuleBL;
  ModelRenderer Chest;
  ModelRenderer Neck;
  ModelRenderer Neck2;
  ModelRenderer Neck3;
  ModelRenderer Neck4;
  ModelRenderer Neck5;
  ModelRenderer Neck6;
  ModelRenderer Neck7;
  ModelRenderer Head;
  ModelRenderer HeadH;
  ModelRenderer Mouth;
  ModelRenderer Trail1;
  ModelRenderer Trail2;
  ModelRenderer Trail3;
  ModelRenderer Trail4;

  public ModelBrachiosaurus()
  {
    this.textureWidth = 512;
    this.textureHeight = 256;

    this.LegFL = new ModelRenderer(this, 168, 0);
    this.LegFL.addBox(0.0F, 0.0F, 0.0F, 10, 24, 10);
    this.LegFL.setRotationPoint(-2.0F, 0.0F, -8.0F);
    this.LegFL.setTextureSize(512, 256);
    this.LegFL.mirror = true;
    setRotation(this.LegFL, 0.0F, 0.0F, 0.0F);
    this.LegFR = new ModelRenderer(this, 208, 0);
    this.LegFR.addBox(0.0F, 0.0F, 0.0F, 10, 24, 10);
    this.LegFR.setRotationPoint(-27.0F, 0.0F, -8.0F);
    this.LegFR.setTextureSize(512, 256);
    this.LegFR.mirror = true;
    setRotation(this.LegFR, 0.0F, 0.0F, 0.0F);
    this.LegBR = new ModelRenderer(this, 168, 34);
    this.LegBR.addBox(0.0F, 0.0F, 0.0F, 10, 24, 10);
    this.LegBR.setRotationPoint(-2.0F, 0.0F, 30.0F);
    this.LegBR.setTextureSize(512, 256);
    this.LegBR.mirror = true;
    setRotation(this.LegBR, 0.0F, 0.0F, 0.0F);
    this.LegBL = new ModelRenderer(this, 208, 34);
    this.LegBL.addBox(0.0F, 0.0F, 0.0F, 10, 24, 10);
    this.LegBL.setRotationPoint(-27.0F, 0.0F, 30.0F);
    this.LegBL.setTextureSize(512, 256);
    this.LegBL.mirror = true;
    setRotation(this.LegBL, 0.0F, 0.0F, 0.0F);
    this.RotuleFL = new ModelRenderer(this, 168, 68);
    this.RotuleFL.addBox(0.0F, 0.0F, 0.0F, 10, 9, 10);
    this.RotuleFL.setRotationPoint(-2.0F, -8.6F, -5.4F);
    this.RotuleFL.setTextureSize(512, 256);
    this.RotuleFL.mirror = true;
    setRotation(this.RotuleFL, -0.297422F, 0.0F, 0.0F);
    this.RotuleFR = new ModelRenderer(this, 208, 68);
    this.RotuleFR.addBox(0.0F, 0.0F, 0.0F, 10, 9, 10);
    this.RotuleFR.setRotationPoint(-27.0F, -8.6F, -5.4F);
    this.RotuleFR.setTextureSize(512, 256);
    this.RotuleFR.mirror = true;
    setRotation(this.RotuleFR, -0.297422F, 0.0F, 0.0F);
    this.RotuleBR = new ModelRenderer(this, 208, 87);
    this.RotuleBR.addBox(0.0F, 0.0F, 0.0F, 10, 9, 10);
    this.RotuleBR.setRotationPoint(-2.0F, -8.6F, 32.599998F);
    this.RotuleBR.setTextureSize(512, 256);
    this.RotuleBR.mirror = true;
    setRotation(this.RotuleBR, -0.297422F, 0.0F, 0.0F);
    this.RotuleBL = new ModelRenderer(this, 168, 87);
    this.RotuleBL.addBox(0.0F, 0.0F, 0.0F, 10, 9, 10);
    this.RotuleBL.setRotationPoint(-27.0F, -8.6F, 32.599998F);
    this.RotuleBL.setTextureSize(512, 256);
    this.RotuleBL.mirror = true;
    setRotation(this.RotuleBL, -0.297422F, 0.0F, 0.0F);
    this.Chest = new ModelRenderer(this, 0, 0);
    this.Chest.addBox(0.0F, 0.0F, 0.0F, 32, 23, 52);
    this.Chest.setRotationPoint(-25.5F, -25.0F, -8.0F);
    this.Chest.setTextureSize(512, 256);
    this.Chest.mirror = true;
    setRotation(this.Chest, -0.074351F, 0.0F, 0.0F);
    this.Neck = new ModelRenderer(this, 248, 0);
    this.Neck.addBox(0.0F, 0.0F, 0.0F, 20, 43, 19);
    this.Neck.setRotationPoint(-20.0F, -46.0F, -24.0F);
    this.Neck.setTextureSize(512, 256);
    this.Neck.mirror = true;
    setRotation(this.Neck, 0.352068F, 0.0F, 0.0F);
    this.Neck2 = new ModelRenderer(this, 248, 62);
    this.Neck2.addBox(0.0F, 0.0F, 0.0F, 15, 27, 15);
    this.Neck2.setRotationPoint(-17.5F, -69.0F, -27.0F);
    this.Neck2.setTextureSize(512, 256);
    this.Neck2.mirror = true;
    setRotation(this.Neck2, 0.223071F, 0.0F, 0.0F);
    this.Neck3 = new ModelRenderer(this, 248, 104);
    this.Neck3.addBox(0.0F, 0.0F, 0.0F, 10, 20, 10);
    this.Neck3.setRotationPoint(-15.0F, -87.0F, -29.0F);
    this.Neck3.setTextureSize(512, 256);
    this.Neck3.mirror = true;
    setRotation(this.Neck3, 0.260246F, 0.0F, 0.0F);
    this.Neck4 = new ModelRenderer(this, 144, 75);
    this.Neck4.addBox(0.0F, -1.0F, 0.0F, 6, 6, 6);
    this.Neck4.setRotationPoint(-13.0F, -91.0F, -28.5F);
    this.Neck4.setTextureSize(512, 256);
    this.Neck4.mirror = true;
    setRotation(this.Neck4, 0.4089656F, 0.0F, 0.0F);
    this.Neck5 = new ModelRenderer(this, 120, 75);
    this.Neck5.addBox(0.0F, 0.0F, 0.0F, 6, 6, 6);
    this.Neck5.setRotationPoint(-13.0F, -96.5F, -31.6F);
    this.Neck5.setTextureSize(512, 256);
    this.Neck5.mirror = true;
    setRotation(this.Neck5, 0.5204921F, 0.0F, 0.0F);
    this.Neck6 = new ModelRenderer(this, 96, 75);
    this.Neck6.addBox(0.0F, 0.0F, 0.0F, 6, 6, 6);
    this.Neck6.setRotationPoint(-13.0F, -99.800003F, -34.799999F);
    this.Neck6.setTextureSize(512, 256);
    this.Neck6.mirror = true;
    setRotation(this.Neck6, 0.74358F, 0.0F, 0.0F);
    this.Neck7 = new ModelRenderer(this, 72, 75);
    this.Neck7.addBox(0.0F, 0.0F, 0.0F, 6, 6, 6);
    this.Neck7.setRotationPoint(-13.0F, -98.599998F, -37.099998F);
    this.Neck7.setTextureSize(512, 256);
    this.Neck7.mirror = true;
    setRotation(this.Neck7, 1.449967F, 0.0F, 0.0F);
    this.Head = new ModelRenderer(this, 0, 75);
    this.Head.addBox(0.0F, 0.0F, 0.0F, 8, 8, 11);
    this.Head.setRotationPoint(-14.0F, -105.5F, -46.0F);
    this.Head.setTextureSize(512, 256);
    this.Head.mirror = true;
    setRotation(this.Head, 0.0F, 0.0F, 0.0F);
    this.HeadH = new ModelRenderer(this, 38, 75);
    this.HeadH.addBox(0.0F, 0.0F, 0.0F, 4, 5, 9);
    this.HeadH.setRotationPoint(-12.0F, -108.0F, -45.0F);
    this.HeadH.setTextureSize(512, 256);
    this.HeadH.mirror = true;
    setRotation(this.HeadH, 0.0F, 0.0F, 0.0F);
    this.Mouth = new ModelRenderer(this, 0, 94);
    this.Mouth.addBox(0.0F, 0.0F, 0.0F, 5, 5, 9);
    this.Mouth.setRotationPoint(-13.0F, -100.0F, -51.0F);
    this.Mouth.setTextureSize(512, 256);
    this.Mouth.mirror = true;
    setRotation(this.Mouth, 0.245062F, 0.0F, 0.0F);
    this.Trail1 = new ModelRenderer(this, 76, 87);
    this.Trail1.addBox(0.0F, 0.0F, 0.0F, 22, 12, 24);
    this.Trail1.setRotationPoint(-20.5F, -19.0F, 42.0F);
    this.Trail1.setTextureSize(512, 256);
    this.Trail1.mirror = true;
    setRotation(this.Trail1, -0.374879F, 0.0F, 0.0F);
    this.Trail2 = new ModelRenderer(this, 168, 106);
    this.Trail2.addBox(0.0F, 0.0F, 0.0F, 17, 10, 21);
    this.Trail2.setRotationPoint(-18.0F, -12.0F, 59.0F);
    this.Trail2.setTextureSize(512, 256);
    this.Trail2.mirror = true;
    setRotation(this.Trail2, -0.5235988F, 0.0F, 0.0F);
    this.Trail3 = new ModelRenderer(this, 0, 108);
    this.Trail3.addBox(0.0F, 0.0F, 0.0F, 14, 8, 12);
    this.Trail3.setRotationPoint(-16.5F, -2.5F, 71.0F);
    this.Trail3.setTextureSize(512, 256);
    this.Trail3.mirror = true;
    setRotation(this.Trail3, -0.2959904F, 0.0F, 0.0F);
    this.Trail4 = new ModelRenderer(this, 128, 123);
    this.Trail4.addBox(0.0F, 0.0F, 0.0F, 9, 5, 11);
    this.Trail4.setRotationPoint(-14.0F, 2.0F, 77.0F);
    this.Trail4.setTextureSize(512, 256);
    this.Trail4.mirror = true;
    setRotation(this.Trail4, -0.0402822F, 0.0F, 0.0F);
  }

  public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
  {
    super.render(entity, f, f1, f2, f3, f4, f5);
    setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    this.LegFL.render(f5);
    this.LegFR.render(f5);
    this.LegBR.render(f5);
    this.LegBL.render(f5);
    this.RotuleFL.render(f5);
    this.RotuleFR.render(f5);
    this.RotuleBR.render(f5);
    this.RotuleBL.render(f5);
    this.Chest.render(f5);
    this.Neck.render(f5);
    this.Neck2.render(f5);
    this.Neck3.render(f5);
    this.Neck4.render(f5);
    this.Neck5.render(f5);
    this.Neck6.render(f5);
    this.Neck7.render(f5);
    this.Head.render(f5);
    this.HeadH.render(f5);
    this.Mouth.render(f5);
    this.Trail1.render(f5);
    this.Trail2.render(f5);
    this.Trail3.render(f5);
    this.Trail4.render(f5);
  }

  private void setRotation(ModelRenderer model, float x, float y, float z)
  {
    model.rotateAngleX = x;
    model.rotateAngleY = y;
    model.rotateAngleZ = z;
  }

  public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity)
  {
    super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    this.LegFL.rotateAngleY = (MathHelper.cos(f * 0.6333056F + 1.0F) * 1.0F * f1);
    this.LegFR.rotateAngleX = (MathHelper.cos(f * 0.6333056F + 3.141593F) * 1.0F * f1);
    this.LegBL.rotateAngleX = (MathHelper.cos(f * 0.6333056F + 3.141593F + 2.0F) * 1.0F * f1);
    this.LegBR.rotateAngleX = (MathHelper.cos(f * 0.6333056F + 1.0F) * 1.0F * f1);
  }
}