package mod;

import java.util.HashMap;

import mod.client.TickClient.TickClientHandlerEvent;
import mod.common.CommonProxy;
import mod.common.block.BlockRegister;
import mod.common.block.entity.RegisterTileEntity;
import mod.common.block.gui.GuiHandler;
import mod.common.block.recipe.RecipeRegisterBlock;
import mod.common.entity.EntityRegister;
import mod.common.item.ItemRegister;
import mod.common.item.recipe.RecipeRegister;
import mod.common.world.biome.BiomeRegister;
import mod.common.world.structure.DimensionRegister;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;


@Mod(modid = DinoCraft.MODID, name = DinoCraft.Name, version = DinoCraft.Version)

public class DinoCraft
{
	public static HashMap<Class, Integer> maptoid;
    public static final String MODID = "dinocraft";
    public static final String Name = "DinoCraft";
    public static final String Version = "1.0";
    @Instance("dinocraft")
    public static DinoCraft instance;


    @SidedProxy(clientSide = "mod.client.ClientProxy", serverSide = "mod.common.CommonProxy")
    public static CommonProxy proxy;

    @EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        BlockRegister.register();
        ItemRegister.register();
      
        if(event.getSide().isClient())
        {
        FMLCommonHandler.instance().bus().register(new TickClientHandlerEvent());
        MinecraftForge.EVENT_BUS.register(new TickClientHandlerEvent());
        }
   

    }

    @EventHandler
    public void init(FMLInitializationEvent event)
    {
        RegisterTileEntity.register();
        RecipeRegister.register();
        RecipeRegisterBlock.register();
        BiomeRegister.register();
        EntityRegister.register();
            
        proxy.register();
        NetworkRegistry.INSTANCE.registerGuiHandler(instance, new GuiHandler());
    }

    @EventHandler
    public void postInit(FMLPostInitializationEvent event)
    {
    	/*DimensionRegister.register();*/
    	maptoid = ObfuscationReflectionHelper.getPrivateValue(EntityList.class, null, "classToIDMapping", "field_75624_e");
    }
}