package com.survivant.mod;

import com.survivant.mod.Capabilities.IThirst;
import com.survivant.mod.Capabilities.ThirstProvider;
import com.survivant.mod.Packet.Message;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent.ElementType;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent.PlayerLoggedInEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent.PlayerRespawnEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SurvivantThirstBar
{
    public static int i = 0;
    
    @SubscribeEvent
    public void onPlayerLogsIn(PlayerLoggedInEvent event)
    {
        EntityPlayer player = event.player;
        IThirst thirst = player.getCapability(ThirstProvider.THIRST_CAP, null);
        ModSurvivant.network.sendTo(new Message(thirst.getThirst()), (EntityPlayerMP)player);
    }
    
    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event)
    {
        EntityPlayer player = event.entityPlayer;
        if (player.worldObj.isRemote)
        {
            return;
        }
        IThirst thirst = player.getCapability(ThirstProvider.THIRST_CAP, null);
    }
    
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event)
    {
        EntityPlayer player = event.entityPlayer;
        IThirst thirst = player.getCapability(ThirstProvider.THIRST_CAP, null);
        thirst.set(86);
    }
    
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event)
    {            
        EntityPlayer player = event.player;
        if (event.side == Side.SERVER)
        {
            IThirst thirst = player.getCapability(ThirstProvider.THIRST_CAP, null);
            if (!player.capabilities.isCreativeMode)
            {
                i++;
                if (i == 700)
                {
                    thirst.consume(1);
                    ModSurvivant.network.sendTo(new Message(thirst.getThirst()), (EntityPlayerMP)player);
                    System.out.println("thirst = " + thirst.getThirst());
                    i = 0;
                }
                if (thirst.getThirst() == 0)
                {
                    player.attackEntityFrom(ModSurvivant.damageSourceDehydration, 1.0F);
                }
            }
        }
    }
    
    
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event)
    {
        if (!event.isCancelable() && event.type == ElementType.EXPERIENCE)
        {
            Minecraft mc = Minecraft.getMinecraft();
            
            if (!mc.thePlayer.capabilities.isCreativeMode)
            {
                EntityPlayer player = mc.thePlayer;
                IThirst thirst = player.getCapability(ThirstProvider.THIRST_CAP, null);
                
                int posX = event.resolution.getScaledWidth() / 2 + 7;
                int posY = event.resolution.getScaledHeight() - 50;
                
                mc.renderEngine.bindTexture(new ResourceLocation("survivant:textures/gui/thirstBar.png"));
                mc.ingameGUI.drawTexturedModalRect(posX, posY, 0, 0, 88, 9);
                mc.ingameGUI.drawTexturedModalRect(posX + 1, posY + 1, 0, 9, (int)thirst.getThirst(), 7);
            }
        }
    }
    
    
}
