package com.survivant.mod;

import java.awt.Color;

import com.jcraft.jogg.Packet;
import com.survivant.mod.Capabilities.CapabilityHandler;
import com.survivant.mod.Packet.Message;
import com.survivant.mod.blocks.BlockMod;
import com.survivant.mod.blocks.BlockPotableWater;
import com.survivant.mod.blocks.PotableWater;
import com.survivant.mod.entity.EntityFish;
import com.survivant.mod.entity.EntityRay;
import com.survivant.mod.entity.EntitySalmon;
import com.survivant.mod.gui.GuiHandlerCampfire;
import com.survivant.mod.handlers.EntityHandler;
import com.survivant.mod.items.ItemMod;
import com.survivant.mod.proxy.CommonProxy;
import com.survivant.mod.tileEntity.TileEntityCampfire;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent.HarvestDropsEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid = Reference.MOD_ID, name = Reference.MOD_NAME, version = Reference.VERSION)

public class ModSurvivant
{
    
    public static SimpleNetworkWrapper network;
    
    @SidedProxy(clientSide = Reference.CLIENT_PROXY_CLASS, serverSide = Reference.SERVER_PROXY_CLASS)
    public static CommonProxy proxy;
    
    @Instance(Reference.MOD_ID)
    public static ModSurvivant instance;
    
    public static CreativeTabs tabSurvivant = new CreativeTabs("tabSurvivant")
    {
        @SideOnly(Side.CLIENT)
        public Item getTabIconItem()
        {
            return Item.getItemFromBlock(BlockMod.blockTotem);
        }
    };
    
    public static PotableWater potable_water = new PotableWater();
    public static BlockPotableWater blockPotableWater;
    
    public static DamageSource damageSourceDehydration;
    
    
    @EventHandler
    public void preInit (FMLPreInitializationEvent event)
    {    
        RemoveRecipes.init();
        damageSourceDehydration = new DamageSource("damageSourceDehydration").setDamageBypassesArmor();
        ItemMod.init();
        ItemMod.register();
        BlockMod.init();
        BlockMod.register();  
        
        /*Eau potable*/
        FluidRegistry.registerFluid(potable_water);
        blockPotableWater = new BlockPotableWater(potable_water);
        GameRegistry.registerBlock(blockPotableWater, "blockPotableWater");
        
        Item item = Item.getItemFromBlock(blockPotableWater);
        ModelBakery.registerItemVariants(item);
        final ModelResourceLocation loc = new ModelResourceLocation("survivant:potable");
        ModelLoader.setCustomMeshDefinition(item, new ItemMeshDefinition()
        {
            @Override
            public ModelResourceLocation getModelLocation(ItemStack stack)
            {
                return loc;
            }
        });
        ModelLoader.setCustomStateMapper(blockPotableWater, new StateMapperBase()
        {
            @Override
            protected ModelResourceLocation getModelResourceLocation(IBlockState state)
            {
                return loc;
            }
        });
        
        network = NetworkRegistry.INSTANCE.newSimpleChannel("MyChannel");
        network.registerMessage(Message.Handler.class, Message.class, 0, Side.CLIENT);
    }
    
    @EventHandler
    public void init (FMLInitializationEvent event)
    {        
        proxy.registerRenders();
        proxy.init(event);
        MinecraftForge.EVENT_BUS.register(new SurvivantBlockEvent());       
        MinecraftForge.EVENT_BUS.register(new SurvivantThirstBar());
        EntityHandler.RegisterFish(EntityFish.class, "Fish");
        EntityHandler.RegisterSalmon(EntitySalmon.class, "Salmon");
        EntityHandler.RegisterRay(EntityRay.class, "Ray");
        GameRegistry.registerTileEntity(TileEntityCampfire.class, "tileentitycampfire");
        NetworkRegistry.INSTANCE.registerGuiHandler(instance, new GuiHandlerCampfire());
    }
    
    @EventHandler
    public void postInit (FMLPostInitializationEvent event)
    {
        
    }
}
