package com.survivant.mod.Packet;

import com.survivant.mod.Capabilities.IThirst;
import com.survivant.mod.Capabilities.ThirstProvider;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Message implements IMessage
{
    private static float thirstVal;
    
    public Message()
    {
        
    }
    
    public Message(float val)
    {
        this.thirstVal = val;
    }

    @Override
    public void fromBytes(ByteBuf buf)
    {
        thirstVal = ByteBufUtils.readVarShort(buf);
    }

    @Override
    public void toBytes(ByteBuf buf)
    {
        ByteBufUtils.writeVarShort(buf, (int)thirstVal);
    }

    public static class Handler implements IMessageHandler<Message, IMessage>
    {

        @Override
        public IMessage onMessage(Message message, MessageContext ctx)
        {
            Minecraft.getMinecraft().addScheduledTask(new Runnable()
            {
                @Override
                public void run()
                {
                    EntityPlayer player = Minecraft.getMinecraft().thePlayer;
                    IThirst thirst = player.getCapability(ThirstProvider.THIRST_CAP, null);
                    thirst.set(message.thirstVal);                
                }               
            });
            return null;
        }
        
    }
}
