package com.survivant.mod.items;

import com.survivant.mod.ModSurvivant;
import com.survivant.mod.SurvivantThirstBar;
import com.survivant.mod.Capabilities.IThirst;
import com.survivant.mod.Capabilities.ThirstProvider;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class GlassOfPotableWater extends Item
{
    public GlassOfPotableWater()
    {
        this.setMaxStackSize(1);
    }
    
    public ItemStack onItemUseFinish(ItemStack stack, World worldIn, EntityPlayer playerIn)
    {
        if (!playerIn.capabilities.isCreativeMode)
        {
            --stack.stackSize;            
            IThirst thirst = playerIn.getCapability(ThirstProvider.THIRST_CAP, null);
            if (thirst.getThirst() <= 56)
            {
                thirst.fill(30);
            }
            else
            {
                thirst.fill(86 - thirst.getThirst());
            }
            playerIn.curePotionEffects(stack);
        }
        return stack.stackSize <= 0 ? new ItemStack(ItemMod.emptyGlass) : stack;
    }
    
    public int getMaxItemUseDuration(ItemStack stack)
    {
        return 30;
    }
    
    public EnumAction getItemUseAction(ItemStack stack)
    {
        return EnumAction.DRINK;
    }
    
    public ItemStack onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn)
    {
        playerIn.setItemInUse(itemStackIn, this.getMaxItemUseDuration(itemStackIn));
        return itemStackIn;
    }
}
