package thecraft.mod.common.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import thecraft.mod.common.ewifaction;

public class ItemExonitArmor extends ItemArmor 
{
	
	public ItemExonitArmor(ArmorMaterial material, int type) 
	{
		super(material, 0, type);
	}
	
	public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type)
    {
		if(slot == 2)
		{
			return ewifaction.MODID + ":textures/models/armor/exonite_1.png";
		}
		return ewifaction.MODID + ":textures/models/armor/exonite_2.png";
		
	}
	
	public boolean getIsRepairable(ItemStack input, ItemStack repairitem)
	{
		if(input.getItem() == this && repairitem.getItem() == ewifaction.itemExonite)
		{
			return true;
		}
		return false;
	}
	
	public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack)
	{
		player.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, 1, 2));
	}
	
}

