package thecraft.mod.common;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class GuiEwiliteChest extends GuiContainer 
{
	private static final ResourceLocation textures = new ResourceLocation(ewifaction.MODID + ":textures/gui/ewilitechestguitex.png");
	   private TileEntityEwiliteChest tileewilite;
	   private IInventory playerInv;
	   
	   public GuiEwiliteChest(TileEntityEwiliteChest tile, InventoryPlayer inventory)
	   {
	       super(new ContainerEwiliteChest(tile, inventory));
	       this.tileewilite = tile;
	       this.playerInv = inventory;
	       this.allowUserInput = false;
	       this.ySize = 170;
	   }

	   @Override
	   protected void drawGuiContainerBackgroundLayer(float partialRenderTick, int x, int y)
	   {
		   String tileName = this.tileewilite.hasCustomInventoryName() ? this.tileewilite.getInventoryName() : I18n.format(this.tileewilite.getInventoryName());
	       this.fontRendererObj.drawString(tileName, (this.xSize - this.fontRendererObj.getStringWidth(tileName)) / 2, 6, 0);
	       String invName = this.playerInv.hasCustomInventoryName() ? this.playerInv.getInventoryName() : I18n.format(this.playerInv.getInventoryName());
	       this.fontRendererObj.drawString(invName, (this.xSize - this.fontRendererObj.getStringWidth(invName)) / 2, this.ySize - 96, 0);
	       GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
	       this.mc.getTextureManager().bindTexture(textures);
	       int k = (this.width - this.xSize) / 2;
	       int l = (this.height - this.ySize) / 2;
	       this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
	   }
}
	   