/*
 * Decompiled with CFR 0.152.
 */
package mod.thecreeper999.api.itemRendererApi;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import cpw.mods.fml.common.asm.transformers.deobf.LZMAInputSupplier;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreeperTranslator
implements IFMLCallHook {
    private String deobFile;
    private String mcLocation;
    private static HashMap<String, String> classNameMap = new HashMap();
    private static HashMap<String, String> fieldNameMap = new HashMap();
    private static HashMap<String, String> methodNameMap = new HashMap();
    private static HashMap<String, String> methodDescMap = new HashMap();

    public static String getMapedFieldName(String className, String fieldName) {
        return fieldNameMap.get(String.valueOf(className) + "." + fieldName);
    }

    public static String getMapedClassName(String className) {
        return classNameMap.get(className);
    }

    public static String getMapedMethodName(String className, String methodName) {
        return methodNameMap.get(String.valueOf(className) + "." + methodName);
    }

    public static String getMapedMethodDesc(String className, String methodName) {
        return methodDescMap.get(String.valueOf(className) + "." + methodName);
    }

    public static void setup(String deobFileName) {
        try {
            LZMAInputSupplier zis = new LZMAInputSupplier(FMLInjectionData.class.getResourceAsStream(deobFileName));
            InputSupplier srgSupplier = CharStreams.newReaderSupplier((InputSupplier)zis, (Charset)Charsets.UTF_8);
            List srgList = CharStreams.readLines((InputSupplier)srgSupplier);
            for (String line : srgList) {
                line.replaceAll(" #C", "");
                line.replaceAll(" #S", "");
                if (line.startsWith("CL")) {
                    CreeperTranslator.parseClass(line);
                    continue;
                }
                if (line.startsWith("FD")) {
                    CreeperTranslator.parseField(line);
                    continue;
                }
                if (!line.startsWith("MD")) continue;
                CreeperTranslator.parseMethod(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Void call() throws Exception {
        CreeperTranslator.setup(this.deobFile);
        return null;
    }

    private static void parseMethod(String line) {
        String[] splitLine = line.split(" ");
        String[] splitObName = splitLine[1].split("/");
        String[] splitTranslatedName = splitLine[3].split("/");
        String key = String.valueOf(splitTranslatedName[splitTranslatedName.length - 2]) + "." + splitTranslatedName[splitTranslatedName.length - 1];
        methodNameMap.put(key, splitObName[splitObName.length - 1]);
        methodDescMap.put(key, splitLine[2]);
    }

    private static void parseField(String line) {
        String[] splitLine = line.split(" ");
        String[] splitObName = splitLine[1].split("/");
        String[] splitTranslatedName = splitLine[2].split("/");
        String key = String.valueOf(splitTranslatedName[splitTranslatedName.length - 2]) + "." + splitTranslatedName[splitTranslatedName.length - 1];
        fieldNameMap.put(key, splitObName[splitObName.length - 1]);
    }

    private static void parseClass(String line) {
        String[] splitLine = line.split(" ");
        String[] splitClassPath = splitLine[2].split("/");
        classNameMap.put(splitClassPath[splitClassPath.length - 1], splitLine[1]);
    }

    public void injectData(Map<String, Object> data) {
        this.deobFile = data.get("deobfuscationFileName").toString();
        this.mcLocation = data.get("mcLocation").toString();
    }
}

