/*
 * Decompiled with CFR 0.152.
 */
package mod.thecreeper999.api.itemRendererApi;

import mod.thecreeper999.api.itemRendererApi.CreeperTranslator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemRendererTransformer
implements IClassTransformer {
    private String itemStackClass;
    private String itemRendererClass;
    private String minecraftClass;
    private String itemRendererMinecraftField;
    private String renderItem1stPersonMethodName;
    private String renderItem1stPersonMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.renderer.ItemRenderer")) {
            System.out.println("ItemRendererAPI - Patching Class ItemRenderer (" + name + ")");
            this.itemStackClass = "net/minecraft/item/ItemStack";
            this.itemRendererClass = "net/minecraft/client/renderer/ItemRenderer";
            this.minecraftClass = "net/minecraft/client/Minecraft";
            System.out.println(String.valueOf(this.itemStackClass) + " " + this.itemRendererClass + " " + this.minecraftClass);
            this.itemRendererMinecraftField = CreeperTranslator.getMapedFieldName("ItemRenderer", "field_78455_a");
            this.renderItem1stPersonMethodName = CreeperTranslator.getMapedMethodName("ItemRenderer", "func_78440_a");
            this.renderItem1stPersonMethodDesc = CreeperTranslator.getMapedMethodDesc("ItemRenderer", "func_78440_a");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            this.processFields(cn);
            for (Object mnObj : cn.methods) {
                MethodNode mn = (MethodNode)mnObj;
                if (!mn.name.equals("renderItemInFirstPerson") || !mn.desc.equals(this.renderItem1stPersonMethodDesc)) continue;
                this.processRenderItemMethod(mn);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("ItemRendererAPI - Patching Class ItemRenderer done");
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processRenderItemMethod(MethodNode mn) {
        System.out.println("\tPatching method renderItemInFirstPerson in ItemRenderer");
        InsnList newList = new InsnList();
        for (AbstractInsnNode insn : mn.instructions) {
            if (insn.getOpcode() == 177) {
                newList.add((AbstractInsnNode)new VarInsnNode(23, 1));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, "mc", "L" + this.minecraftClass + ";"));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.itemRendererClass, "offHandItemToRender", "L" + this.itemStackClass + ";"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mod/thecreeper999/api/itemRendererApi/CreeperUtils", "registerItemRendererEventFirst", "(FL" + this.minecraftClass + ";L" + this.itemRendererClass + ";L" + this.itemStackClass + ";)V"));
            }
            newList.add(insn);
        }
        mn.instructions = newList;
    }

    private void processFields(ClassNode cn) {
        System.out.println("\tAdding new fields to ItemRenderer");
        cn.fields.add(0, new FieldNode(1, "offHandItemToRender", "L" + this.itemStackClass + ";", null, null));
        cn.fields.add(1, new FieldNode(1, "equippedItemOffhandSlot", "I", null, (Object)0));
        cn.fields.add(2, new FieldNode(1, "equippedOffHandProgress", "F", null, (Object)Float.valueOf(0.0f)));
        cn.fields.add(3, new FieldNode(1, "prevEquippedOffHandProgress", "F", null, (Object)Float.valueOf(0.0f)));
    }
}

