/*
 * Decompiled with CFR 0.152.
 */
package paintingmodified.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    private static Date date;
    private static String path;
    private static String logfile;
    private static FileWriter writer;
    private static SimpleDateFormat formater;
    private static Log thislog;

    private Log() {
        path = Log.getpath();
        logfile = this.createlog();
    }

    private static String getpath() {
        if (path == null) {
            try {
                path = new File(".").getCanonicalPath() + "/" + "Painting Modified" + " Logs/";
            }
            catch (IOException e) {
                System.err.println("Caught IOException: " + e.getMessage());
            }
        }
        return path;
    }

    private static void WritetoFile(String texte) {
        try {
            writer = new FileWriter(logfile, true);
            writer.write(texte, 0, texte.length());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String createlog() {
        date = new Date();
        formater = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        logfile = path + "PM1.0" + "(" + formater.format(date) + ").log";
        File f = new File(logfile);
        File p = f.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Caught IOException: " + e.getMessage());
            }
        }
        formater = null;
        return logfile;
    }

    public static void ToLog(String data) {
        thislog = Log.getthisLog();
        date = new Date();
        formater = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        System.out.println("[" + formater.format(date) + "][" + "PM1.0" + "] " + data);
        try {
            Log.WritetoFile("[" + formater.format(date) + "][" + "PM1.0" + "] " + data + System.getProperty("line.separator"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        formater = null;
    }

    private static Log getthisLog() {
        if (thislog == null) {
            thislog = new Log();
        }
        return thislog;
    }

    static {
        path = null;
        logfile = null;
        writer = null;
        formater = null;
    }
}

