package fr.premiermod.minecraft.client;

import java.io.File;

import fr.premiermod.minecraft.PremierModCommon;
import fr.premiermod.minecraft.items.ItemRubilax;
import fr.premiermod.minecraft.items.Wakfuitems;
import net.minecraft.block.Block;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;

public class PremierModClient extends PremierModCommon
{
    @Override
    public void preInit(File configFile)
    {
        super.preInit(configFile);
        Wakfuitems.registerItemsModels();
    }

    @Override
    public void init()
    {
        super.init();

    }

    @Override
    public void registerItemTexture(Item item, int metadata, String name)
    {
        ModelLoader.setCustomModelResourceLocation(item, metadata, new ModelResourceLocation("wakfu:" + name, "inventory"));
    }

    @Override
    public void registerItemTexture(Item item, String name)
    {
        registerItemTexture(item, 0, name);
    }

    @Override
    public void registerBlockTexture(Block block, int metadata, String name)
    {
        registerItemTexture(Item.getItemFromBlock(block), metadata, name);
    }

    @Override
    public void registerBlockTexture(Block block, String name)
    {
        registerBlockTexture(block, 0, name);
    }
}
