package fr.premiermod.minecraft;

import org.apache.logging.log4j.Logger;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid = ModMinecraft.MODID, name = "Mod Minecraft", version = "0.1", acceptedMinecraftVersions = "[1.8.9]")
public class ModMinecraft
{
    public static final String MODID = "wakfu";

    @Instance(ModMinecraft.MODID)
    public static ModMinecraft instance;

    @SidedProxy(clientSide = "fr.premiermod.minecraft.client.PremierModClient", serverSide = "fr.premiermod.minecraft.server.PremierModServer")
    public static PremierModCommon proxy;

    public static Block wakfuBlock;

    public static Logger logger;

    @EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        ModMinecraft.logger = event.getModLog();
        ModMinecraft.proxy.preInit(event.getSuggestedConfigurationFile());
        wakfuBlock = new WakfuBlock(Material.rock).setUnlocalizedName("wakfu_bloc").setHardness(8.0F).setCreativeTab(CreativeTabs.tabMaterials);
        GameRegistry.registerBlock(wakfuBlock, "wakfu_bloc");
        proxy.registerBlockTexture(wakfuBlock, "wakfu_bloc");

    }

    public void init(FMLInitializationEvent event)
    {
        ModMinecraft.proxy.init();
    }
}